/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.shards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.shards.ShardMonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;

public class ShardsCollector
extends Collector {
    public ShardsCollector(Settings settings, ClusterService clusterService, XPackLicenseState licenseState) {
        super(settings, "shards", clusterService, null, licenseState);
    }

    @Override
    protected boolean shouldCollect(boolean isElectedMaster) {
        return isElectedMaster && super.shouldCollect(isElectedMaster);
    }

    @Override
    protected Collection<MonitoringDoc> doCollect(MonitoringDoc.Node node, long interval, ClusterState clusterState) throws Exception {
        List shards;
        RoutingTable routingTable;
        ArrayList<ShardMonitoringDoc> results = new ArrayList<ShardMonitoringDoc>(1);
        if (clusterState != null && (routingTable = clusterState.routingTable()) != null && (shards = routingTable.allShards()) != null) {
            String clusterUuid = ShardsCollector.clusterUuid(clusterState);
            String stateUUID = clusterState.stateUUID();
            long timestamp = ShardsCollector.timestamp();
            String[] indices = this.getCollectionIndices();
            boolean isAllIndices = IndexNameExpressionResolver.isAllIndices(Arrays.asList(indices));
            for (ShardRouting shard : shards) {
                if (!isAllIndices && !Regex.simpleMatch((String[])indices, (String)shard.getIndexName())) continue;
                MonitoringDoc.Node shardNode = null;
                if (shard.assignedToNode()) {
                    shardNode = ShardsCollector.convertNode(node.getTimestamp(), clusterState.getNodes().get(shard.currentNodeId()));
                }
                results.add(new ShardMonitoringDoc(clusterUuid, timestamp, interval, shardNode, shard, stateUUID));
            }
        }
        return Collections.unmodifiableCollection(results);
    }
}

