/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.cluster;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.action.XPackUsageRequestBuilder;
import org.elasticsearch.xpack.action.XPackUsageResponse;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.cluster.ClusterStatsMonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;

public class ClusterStatsCollector
extends Collector {
    public static final Setting<TimeValue> CLUSTER_STATS_TIMEOUT = ClusterStatsCollector.collectionTimeoutSetting("cluster.stats.timeout");
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final LicenseService licenseService;
    private final Client client;

    public ClusterStatsCollector(Settings settings, ClusterService clusterService, XPackLicenseState licenseState, Client client, LicenseService licenseService) {
        this(settings, clusterService, licenseState, client, licenseService, new IndexNameExpressionResolver(Settings.EMPTY));
    }

    ClusterStatsCollector(Settings settings, ClusterService clusterService, XPackLicenseState licenseState, Client client, LicenseService licenseService, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster_stats", clusterService, CLUSTER_STATS_TIMEOUT, licenseState);
        this.client = client;
        this.licenseService = licenseService;
        this.indexNameExpressionResolver = Objects.requireNonNull(indexNameExpressionResolver);
    }

    @Override
    protected boolean shouldCollect(boolean isElectedMaster) {
        return isElectedMaster;
    }

    @Override
    protected Collection<MonitoringDoc> doCollect(MonitoringDoc.Node node, long interval, ClusterState clusterState) throws Exception {
        Supplier clusterStatsSupplier = () -> (ClusterStatsResponse)this.client.admin().cluster().prepareClusterStats().get(this.getCollectionTimeout());
        Supplier usageSupplier = () -> ((XPackUsageResponse)new XPackUsageRequestBuilder((ElasticsearchClient)this.client).get()).getUsages();
        ClusterStatsResponse clusterStats = (ClusterStatsResponse)clusterStatsSupplier.get();
        String clusterName = this.clusterService.getClusterName().value();
        String clusterUuid = ClusterStatsCollector.clusterUuid(clusterState);
        String version = Version.CURRENT.toString();
        License license = this.licenseService.getLicense();
        List xpackUsage = (List)this.collect(usageSupplier);
        boolean apmIndicesExist = this.doAPMIndicesExist(clusterState);
        boolean clusterNeedsTLSEnabled = license.operationMode() == License.OperationMode.TRIAL && (Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings) != false && (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(this.settings) == false;
        return Collections.singleton(new ClusterStatsMonitoringDoc(clusterUuid, ClusterStatsCollector.timestamp(), interval, node, clusterName, version, clusterStats.getStatus(), license, apmIndicesExist, xpackUsage, clusterStats, clusterState, clusterNeedsTLSEnabled));
    }

    boolean doAPMIndicesExist(ClusterState clusterState) {
        try {
            Index[] indices = this.indexNameExpressionResolver.concreteIndices(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{"apm-*"});
            return indices.length > 0;
        }
        catch (IllegalArgumentException | IndexNotFoundException e) {
            return false;
        }
    }

    @Nullable
    private <T> T collect(Supplier<T> supplier) {
        try {
            return (T)supplier.get();
        }
        catch (ElasticsearchSecurityException e) {
            if (!LicenseUtils.isLicenseExpiredException(e)) {
                throw e;
            }
            this.logger.trace(() -> new ParameterizedMessage("collector [{}] - unable to collect data because of expired license", (Object)this.name()), (Throwable)e);
            return null;
        }
    }
}

