/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.action;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.monitoring.action.MonitoringBulkDoc;
import org.elasticsearch.xpack.monitoring.action.MonitoringBulkRequest;
import org.elasticsearch.xpack.monitoring.action.MonitoringBulkResponse;
import org.elasticsearch.xpack.monitoring.exporter.BytesReferenceMonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.Exporters;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;

public class TransportMonitoringBulkAction
extends HandledTransportAction<MonitoringBulkRequest, MonitoringBulkResponse> {
    private final ClusterService clusterService;
    private final Exporters exportService;

    @Inject
    public TransportMonitoringBulkAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Exporters exportService) {
        super(settings, "cluster:admin/xpack/monitoring/bulk", threadPool, transportService, actionFilters, indexNameExpressionResolver, MonitoringBulkRequest::new);
        this.clusterService = clusterService;
        this.exportService = exportService;
    }

    protected void doExecute(MonitoringBulkRequest request, ActionListener<MonitoringBulkResponse> listener) {
        this.clusterService.state().blocks().globalBlockedRaiseException(ClusterBlockLevel.WRITE);
        long timestamp = System.currentTimeMillis();
        String cluster = this.clusterService.state().metaData().clusterUUID();
        DiscoveryNode discoveryNode = this.clusterService.localNode();
        MonitoringDoc.Node node = new MonitoringDoc.Node(discoveryNode.getId(), discoveryNode.getHostName(), discoveryNode.getAddress().toString(), discoveryNode.getHostAddress(), discoveryNode.getName(), timestamp);
        new AsyncAction(request, listener, this.exportService, cluster, timestamp, node).start();
    }

    private static MonitoringBulkResponse response(long start) {
        return new MonitoringBulkResponse(TransportMonitoringBulkAction.took(start));
    }

    private static MonitoringBulkResponse response(long start, Exception e) {
        return new MonitoringBulkResponse(TransportMonitoringBulkAction.took(start), new MonitoringBulkResponse.Error(e));
    }

    private static long took(long start) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
    }

    static class AsyncAction {
        private final MonitoringBulkRequest request;
        private final ActionListener<MonitoringBulkResponse> listener;
        private final Exporters exportService;
        private final String defaultClusterUUID;
        private final long defaultTimestamp;
        private final MonitoringDoc.Node defaultNode;

        AsyncAction(MonitoringBulkRequest request, ActionListener<MonitoringBulkResponse> listener, Exporters exportService, String defaultClusterUUID, long defaultTimestamp, MonitoringDoc.Node defaultNode) {
            this.request = request;
            this.listener = listener;
            this.exportService = exportService;
            this.defaultClusterUUID = defaultClusterUUID;
            this.defaultTimestamp = defaultTimestamp;
            this.defaultNode = defaultNode;
        }

        void start() {
            this.executeExport(this.createMonitoringDocs(this.request.getDocs()), System.nanoTime(), this.listener);
        }

        Collection<MonitoringDoc> createMonitoringDocs(Collection<MonitoringBulkDoc> bulkDocs) {
            return bulkDocs.stream().filter(bulkDoc -> bulkDoc.getSystem() != MonitoredSystem.UNKNOWN).map(this::createMonitoringDoc).collect(Collectors.toList());
        }

        MonitoringDoc createMonitoringDoc(MonitoringBulkDoc bulkDoc) {
            MonitoredSystem system = bulkDoc.getSystem();
            String type = bulkDoc.getType();
            String id = bulkDoc.getId();
            long intervalMillis = bulkDoc.getIntervalMillis();
            XContentType xContentType = bulkDoc.getXContentType();
            BytesReference source = bulkDoc.getSource();
            long timestamp = bulkDoc.getTimestamp() != 0L ? bulkDoc.getTimestamp() : this.defaultTimestamp;
            return new BytesReferenceMonitoringDoc(this.defaultClusterUUID, timestamp, intervalMillis, this.defaultNode, system, type, id, xContentType, source);
        }

        void executeExport(Collection<MonitoringDoc> docs, long startTimeNanos, ActionListener<MonitoringBulkResponse> listener) {
            try {
                this.exportService.export(docs, (ActionListener<Void>)ActionListener.wrap(r -> listener.onResponse((Object)TransportMonitoringBulkAction.response(startTimeNanos)), e -> listener.onResponse((Object)TransportMonitoringBulkAction.response(startTimeNanos, e))));
            }
            catch (Exception e2) {
                listener.onResponse((Object)TransportMonitoringBulkAction.response(startTimeNanos, e2));
            }
        }
    }
}

