/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring;

import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Stream;

public enum MonitoredSystem {
    ES("es"),
    KIBANA("kibana"),
    LOGSTASH("logstash"),
    UNKNOWN("unknown");

    private final String system;

    private MonitoredSystem(String system) {
        this.system = system;
    }

    public String getSystem() {
        return this.system;
    }

    public static MonitoredSystem fromSystem(String system) {
        switch (system.toLowerCase(Locale.ROOT)) {
            case "es": {
                return ES;
            }
            case "kibana": {
                return KIBANA;
            }
            case "logstash": {
                return LOGSTASH;
            }
        }
        return UNKNOWN;
    }

    public static Stream<MonitoredSystem> allSystems() {
        return Arrays.stream(MonitoredSystem.values()).filter(s -> s != UNKNOWN);
    }
}

