/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.job.results.Forecast;
import org.elasticsearch.xpack.ml.job.results.ForecastRequestStats;
import org.elasticsearch.xpack.ml.job.results.Result;
import org.elasticsearch.xpack.ml.job.retention.MlDataRemover;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

public class ExpiredForecastsRemover
implements MlDataRemover {
    private static final Logger LOGGER = Loggers.getLogger(ExpiredForecastsRemover.class);
    private static final int MAX_FORECASTS = 10000;
    private static final String RESULTS_INDEX_PATTERN = AnomalyDetectorsIndex.jobResultsIndexPrefix() + "*";
    private final Client client;
    private final long cutoffEpochMs;

    public ExpiredForecastsRemover(Client client) {
        this.client = Objects.requireNonNull(client);
        this.cutoffEpochMs = DateTime.now((Chronology)ISOChronology.getInstance()).getMillis();
    }

    @Override
    public void remove(ActionListener<Boolean> listener) {
        LOGGER.debug("Removing forecasts that expire before [{}]", (Object)this.cutoffEpochMs);
        ActionListener forecastStatsHandler = ActionListener.wrap(searchResponse -> this.deleteForecasts((SearchResponse)searchResponse, listener), e -> listener.onFailure((Exception)new ElasticsearchException("An error occurred while searching forecasts to delete", (Throwable)e, new Object[0])));
        SearchSourceBuilder source = new SearchSourceBuilder();
        source.query((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)Result.RESULT_TYPE.getPreferredName(), (String)"model_forecast_request_stats")).filter((QueryBuilder)QueryBuilders.existsQuery((String)ForecastRequestStats.EXPIRY_TIME.getPreferredName())));
        source.size(10000);
        SearchRequest searchRequest = new SearchRequest(new String[]{RESULTS_INDEX_PATTERN});
        searchRequest.source(source);
        this.client.execute((Action)SearchAction.INSTANCE, (ActionRequest)searchRequest, forecastStatsHandler);
    }

    private void deleteForecasts(SearchResponse searchResponse, final ActionListener<Boolean> listener) {
        List<ForecastRequestStats> forecastsToDelete;
        try {
            forecastsToDelete = this.findForecastsToDelete(searchResponse);
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
            return;
        }
        DeleteByQueryRequest request = this.buildDeleteByQuery(forecastsToDelete);
        this.client.execute((Action)DeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<BulkByScrollResponse>(){

            public void onResponse(BulkByScrollResponse bulkByScrollResponse) {
                try {
                    if (bulkByScrollResponse.getDeleted() > 0L) {
                        LOGGER.info("Deleted [{}] documents corresponding to [{}] expired forecasts", (Object)bulkByScrollResponse.getDeleted(), (Object)forecastsToDelete.size());
                    }
                    listener.onResponse((Object)true);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure((Exception)new ElasticsearchException("Failed to remove expired forecasts", (Throwable)e, new Object[0]));
            }
        });
    }

    private List<ForecastRequestStats> findForecastsToDelete(SearchResponse searchResponse) throws IOException {
        ArrayList<ForecastRequestStats> forecastsToDelete = new ArrayList<ForecastRequestStats>();
        SearchHits hits = searchResponse.getHits();
        if (hits.getTotalHits() > 10000L) {
            LOGGER.info("More than [{}] forecasts were found. This run will only delete [{}] of them", (Object)10000, (Object)10000);
        }
        for (SearchHit hit : hits.getHits()) {
            XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, hit.getSourceRef());
            ForecastRequestStats forecastRequestStats = (ForecastRequestStats)ForecastRequestStats.PARSER.apply(parser, null);
            if (forecastRequestStats.getExpiryTime().toEpochMilli() >= this.cutoffEpochMs) continue;
            forecastsToDelete.add(forecastRequestStats);
        }
        return forecastsToDelete;
    }

    private DeleteByQueryRequest buildDeleteByQuery(List<ForecastRequestStats> forecastsToDelete) {
        SearchRequest searchRequest = new SearchRequest();
        DeleteByQueryRequest request = new DeleteByQueryRequest(searchRequest);
        request.setSlices(5);
        searchRequest.indices(new String[]{RESULTS_INDEX_PATTERN});
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().minimumShouldMatch(1);
        boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)Result.RESULT_TYPE.getPreferredName(), (String[])new String[]{"model_forecast_request_stats", "model_forecast"}));
        for (ForecastRequestStats forecastToDelete : forecastsToDelete) {
            boolQuery.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)forecastToDelete.getJobId())).must((QueryBuilder)QueryBuilders.termQuery((String)Forecast.FORECAST_ID.getPreferredName(), (String)forecastToDelete.getForecastId())));
        }
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)boolQuery);
        searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)query));
        return request;
    }
}

