/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.results;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ml.job.results.Influence;

public class AnomalyCause
implements ToXContentObject,
Writeable {
    public static final ParseField ANOMALY_CAUSE = new ParseField("anomaly_cause", new String[0]);
    public static final ParseField PROBABILITY = new ParseField("probability", new String[0]);
    public static final ParseField OVER_FIELD_NAME = new ParseField("over_field_name", new String[0]);
    public static final ParseField OVER_FIELD_VALUE = new ParseField("over_field_value", new String[0]);
    public static final ParseField BY_FIELD_NAME = new ParseField("by_field_name", new String[0]);
    public static final ParseField BY_FIELD_VALUE = new ParseField("by_field_value", new String[0]);
    public static final ParseField CORRELATED_BY_FIELD_VALUE = new ParseField("correlated_by_field_value", new String[0]);
    public static final ParseField PARTITION_FIELD_NAME = new ParseField("partition_field_name", new String[0]);
    public static final ParseField PARTITION_FIELD_VALUE = new ParseField("partition_field_value", new String[0]);
    public static final ParseField FUNCTION = new ParseField("function", new String[0]);
    public static final ParseField FUNCTION_DESCRIPTION = new ParseField("function_description", new String[0]);
    public static final ParseField TYPICAL = new ParseField("typical", new String[0]);
    public static final ParseField ACTUAL = new ParseField("actual", new String[0]);
    public static final ParseField INFLUENCERS = new ParseField("influencers", new String[0]);
    public static final ParseField FIELD_NAME = new ParseField("field_name", new String[0]);
    public static final ObjectParser<AnomalyCause, Void> PARSER = new ObjectParser(ANOMALY_CAUSE.getPreferredName(), AnomalyCause::new);
    private double probability;
    private String byFieldName;
    private String byFieldValue;
    private String correlatedByFieldValue;
    private String partitionFieldName;
    private String partitionFieldValue;
    private String function;
    private String functionDescription;
    private List<Double> typical;
    private List<Double> actual;
    private String fieldName;
    private String overFieldName;
    private String overFieldValue;
    private List<Influence> influencers;

    public AnomalyCause() {
    }

    public AnomalyCause(StreamInput in) throws IOException {
        this.probability = in.readDouble();
        this.byFieldName = in.readOptionalString();
        this.byFieldValue = in.readOptionalString();
        this.correlatedByFieldValue = in.readOptionalString();
        this.partitionFieldName = in.readOptionalString();
        this.partitionFieldValue = in.readOptionalString();
        this.function = in.readOptionalString();
        this.functionDescription = in.readOptionalString();
        if (in.readBoolean()) {
            this.typical = (List)in.readGenericValue();
        }
        if (in.readBoolean()) {
            this.actual = (List)in.readGenericValue();
        }
        this.fieldName = in.readOptionalString();
        this.overFieldName = in.readOptionalString();
        this.overFieldValue = in.readOptionalString();
        if (in.readBoolean()) {
            this.influencers = in.readList(Influence::new);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.probability);
        out.writeOptionalString(this.byFieldName);
        out.writeOptionalString(this.byFieldValue);
        out.writeOptionalString(this.correlatedByFieldValue);
        out.writeOptionalString(this.partitionFieldName);
        out.writeOptionalString(this.partitionFieldValue);
        out.writeOptionalString(this.function);
        out.writeOptionalString(this.functionDescription);
        boolean hasTypical = this.typical != null;
        out.writeBoolean(hasTypical);
        if (hasTypical) {
            out.writeGenericValue(this.typical);
        }
        boolean hasActual = this.actual != null;
        out.writeBoolean(hasActual);
        if (hasActual) {
            out.writeGenericValue(this.actual);
        }
        out.writeOptionalString(this.fieldName);
        out.writeOptionalString(this.overFieldName);
        out.writeOptionalString(this.overFieldValue);
        boolean hasInfluencers = this.influencers != null;
        out.writeBoolean(hasInfluencers);
        if (hasInfluencers) {
            out.writeList(this.influencers);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(PROBABILITY.getPreferredName(), this.probability);
        if (this.byFieldName != null) {
            builder.field(BY_FIELD_NAME.getPreferredName(), this.byFieldName);
        }
        if (this.byFieldValue != null) {
            builder.field(BY_FIELD_VALUE.getPreferredName(), this.byFieldValue);
        }
        if (this.correlatedByFieldValue != null) {
            builder.field(CORRELATED_BY_FIELD_VALUE.getPreferredName(), this.correlatedByFieldValue);
        }
        if (this.partitionFieldName != null) {
            builder.field(PARTITION_FIELD_NAME.getPreferredName(), this.partitionFieldName);
        }
        if (this.partitionFieldValue != null) {
            builder.field(PARTITION_FIELD_VALUE.getPreferredName(), this.partitionFieldValue);
        }
        if (this.function != null) {
            builder.field(FUNCTION.getPreferredName(), this.function);
        }
        if (this.functionDescription != null) {
            builder.field(FUNCTION_DESCRIPTION.getPreferredName(), this.functionDescription);
        }
        if (this.typical != null) {
            builder.field(TYPICAL.getPreferredName(), this.typical);
        }
        if (this.actual != null) {
            builder.field(ACTUAL.getPreferredName(), this.actual);
        }
        if (this.fieldName != null) {
            builder.field(FIELD_NAME.getPreferredName(), this.fieldName);
        }
        if (this.overFieldName != null) {
            builder.field(OVER_FIELD_NAME.getPreferredName(), this.overFieldName);
        }
        if (this.overFieldValue != null) {
            builder.field(OVER_FIELD_VALUE.getPreferredName(), this.overFieldValue);
        }
        if (this.influencers != null) {
            builder.field(INFLUENCERS.getPreferredName(), this.influencers);
        }
        builder.endObject();
        return builder;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double value) {
        this.probability = value;
    }

    public String getByFieldName() {
        return this.byFieldName;
    }

    public void setByFieldName(String value) {
        this.byFieldName = value.intern();
    }

    public String getByFieldValue() {
        return this.byFieldValue;
    }

    public void setByFieldValue(String value) {
        this.byFieldValue = value.intern();
    }

    public String getCorrelatedByFieldValue() {
        return this.correlatedByFieldValue;
    }

    public void setCorrelatedByFieldValue(String value) {
        this.correlatedByFieldValue = value.intern();
    }

    public String getPartitionFieldName() {
        return this.partitionFieldName;
    }

    public void setPartitionFieldName(String field) {
        this.partitionFieldName = field.intern();
    }

    public String getPartitionFieldValue() {
        return this.partitionFieldValue;
    }

    public void setPartitionFieldValue(String value) {
        this.partitionFieldValue = value.intern();
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String name) {
        this.function = name.intern();
    }

    public String getFunctionDescription() {
        return this.functionDescription;
    }

    public void setFunctionDescription(String functionDescription) {
        this.functionDescription = functionDescription.intern();
    }

    public List<Double> getTypical() {
        return this.typical;
    }

    public void setTypical(List<Double> typical) {
        this.typical = typical;
    }

    public List<Double> getActual() {
        return this.actual;
    }

    public void setActual(List<Double> actual) {
        this.actual = actual;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String field) {
        this.fieldName = field.intern();
    }

    public String getOverFieldName() {
        return this.overFieldName;
    }

    public void setOverFieldName(String name) {
        this.overFieldName = name.intern();
    }

    public String getOverFieldValue() {
        return this.overFieldValue;
    }

    public void setOverFieldValue(String value) {
        this.overFieldValue = value.intern();
    }

    public List<Influence> getInfluencers() {
        return this.influencers;
    }

    public void setInfluencers(List<Influence> influencers) {
        this.influencers = influencers;
    }

    public int hashCode() {
        return Objects.hash(this.probability, this.actual, this.typical, this.byFieldName, this.byFieldValue, this.correlatedByFieldValue, this.fieldName, this.function, this.functionDescription, this.overFieldName, this.overFieldValue, this.partitionFieldName, this.partitionFieldValue, this.influencers);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnomalyCause)) {
            return false;
        }
        AnomalyCause that = (AnomalyCause)other;
        return this.probability == that.probability && Objects.deepEquals(this.typical, that.typical) && Objects.deepEquals(this.actual, that.actual) && Objects.equals(this.function, that.function) && Objects.equals(this.functionDescription, that.functionDescription) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.byFieldName, that.byFieldName) && Objects.equals(this.byFieldValue, that.byFieldValue) && Objects.equals(this.correlatedByFieldValue, that.correlatedByFieldValue) && Objects.equals(this.partitionFieldName, that.partitionFieldName) && Objects.equals(this.partitionFieldValue, that.partitionFieldValue) && Objects.equals(this.overFieldName, that.overFieldName) && Objects.equals(this.overFieldValue, that.overFieldValue) && Objects.equals(this.influencers, that.influencers);
    }

    static {
        PARSER.declareDouble(AnomalyCause::setProbability, PROBABILITY);
        PARSER.declareString(AnomalyCause::setByFieldName, BY_FIELD_NAME);
        PARSER.declareString(AnomalyCause::setByFieldValue, BY_FIELD_VALUE);
        PARSER.declareString(AnomalyCause::setCorrelatedByFieldValue, CORRELATED_BY_FIELD_VALUE);
        PARSER.declareString(AnomalyCause::setPartitionFieldName, PARTITION_FIELD_NAME);
        PARSER.declareString(AnomalyCause::setPartitionFieldValue, PARTITION_FIELD_VALUE);
        PARSER.declareString(AnomalyCause::setFunction, FUNCTION);
        PARSER.declareString(AnomalyCause::setFunctionDescription, FUNCTION_DESCRIPTION);
        PARSER.declareDoubleArray(AnomalyCause::setTypical, TYPICAL);
        PARSER.declareDoubleArray(AnomalyCause::setActual, ACTUAL);
        PARSER.declareString(AnomalyCause::setFieldName, FIELD_NAME);
        PARSER.declareString(AnomalyCause::setOverFieldName, OVER_FIELD_NAME);
        PARSER.declareString(AnomalyCause::setOverFieldValue, OVER_FIELD_VALUE);
        PARSER.declareObjectArray(AnomalyCause::setInfluencers, Influence.PARSER, INFLUENCERS);
    }
}

