/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.ml.job.config.DataDescription;
import org.elasticsearch.xpack.ml.job.process.DataCountsReporter;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.AbstractDataToProcessWriter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.XContentRecordReader;

class JsonDataToProcessWriter
extends AbstractDataToProcessWriter {
    private static final Logger LOGGER = Loggers.getLogger(JsonDataToProcessWriter.class);
    private NamedXContentRegistry xContentRegistry;

    JsonDataToProcessWriter(boolean includeControlField, AutodetectProcess autodetectProcess, DataDescription dataDescription, AnalysisConfig analysisConfig, DataCountsReporter dataCountsReporter, NamedXContentRegistry xContentRegistry) {
        super(includeControlField, autodetectProcess, dataDescription, analysisConfig, dataCountsReporter, LOGGER);
        this.xContentRegistry = xContentRegistry;
    }

    @Override
    public void write(InputStream inputStream, XContentType xContentType, BiConsumer<DataCounts, Exception> handler) throws IOException {
        this.dataCountsReporter.startNewIncrementalCount();
        if (xContentType.equals((Object)XContentType.JSON)) {
            this.writeJsonXContent(inputStream);
        } else if (xContentType.equals((Object)XContentType.SMILE)) {
            this.writeSmileXContent(inputStream);
        } else {
            throw new RuntimeException("XContentType [" + xContentType + "] is not supported by JsonDataToProcessWriter");
        }
        this.dataCountsReporter.finishReporting((ActionListener<Boolean>)ActionListener.wrap(response -> handler.accept(this.dataCountsReporter.incrementalStats(), null), e -> handler.accept((DataCounts)null, (Exception)e)));
    }

    private void writeJsonXContent(InputStream inputStream) throws IOException {
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(this.xContentRegistry, inputStream);){
            this.writeJson(parser);
        }
    }

    private void writeSmileXContent(InputStream inputStream) throws IOException {
        byte[] nextObject;
        while ((nextObject = this.findNextObject(XContentType.SMILE.xContent().streamSeparator(), inputStream)).length != 0) {
            XContentParser parser = XContentFactory.xContent((XContentType)XContentType.SMILE).createParser(this.xContentRegistry, nextObject);
            Throwable throwable = null;
            try {
                this.writeJson(parser);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (parser == null) continue;
                if (throwable != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                parser.close();
            }
        }
    }

    private byte[] findNextObject(byte marker, InputStream data) throws IOException {
        int nextByte;
        assert (data.markSupported());
        data.mark(-1);
        int counter = 0;
        do {
            nextByte = data.read();
            ++counter;
            if (nextByte != (marker & 0xFF)) continue;
            data.reset();
            byte[] buffer = new byte[counter];
            data.read(buffer);
            return buffer;
        } while (nextByte != -1);
        return new byte[0];
    }

    private void writeJson(XContentParser parser) throws IOException {
        Collection<String> analysisFields = this.inputFields();
        this.buildFieldIndexMapping(analysisFields.toArray(new String[0]));
        int numFields = this.outputFieldCount();
        String[] input = new String[numFields];
        Object[] record = new String[numFields];
        boolean[] gotFields = new boolean[analysisFields.size()];
        XContentRecordReader recordReader = new XContentRecordReader(parser, this.inFieldIndexes, LOGGER);
        long inputFieldCount = recordReader.read(input, gotFields);
        while (inputFieldCount >= 0L) {
            Arrays.fill(record, "");
            inputFieldCount = Math.max(inputFieldCount - 1L, 0L);
            long missing = JsonDataToProcessWriter.missingFieldCount(gotFields);
            if (missing > 0L) {
                this.dataCountsReporter.reportMissingFields(missing);
            }
            for (AbstractDataToProcessWriter.InputOutputMap inOut : this.inputOutputMap) {
                String field = input[inOut.inputIndex];
                record[inOut.outputIndex] = field == null ? "" : field;
            }
            this.transformTimeAndWrite((String[])record, inputFieldCount);
            inputFieldCount = recordReader.read(input, gotFields);
        }
    }

    @Override
    protected boolean checkForMissingFields(Collection<String> inputFields, Map<String, Integer> inputFieldIndexes, String[] header) {
        return true;
    }

    private static long missingFieldCount(boolean[] gotFieldFlags) {
        long count = 0L;
        for (int i = 0; i < gotFieldFlags.length; ++i) {
            if (gotFieldFlags[i]) continue;
            ++count;
        }
        return count;
    }
}

