/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.state;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ml.job.config.Job;

public class Quantiles
implements ToXContentObject,
Writeable {
    public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    public static final ParseField QUANTILE_STATE = new ParseField("quantile_state", new String[0]);
    public static final ParseField TYPE = new ParseField("quantiles", new String[0]);
    public static final ConstructingObjectParser<Quantiles, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), a -> new Quantiles((String)a[0], (Date)a[1], (String)a[2]));
    private final String jobId;
    private final Date timestamp;
    private final String quantileState;

    public static String documentId(String jobId) {
        return jobId + "_" + TYPE;
    }

    public static String v54DocumentId(String jobId) {
        return jobId + "-" + TYPE;
    }

    public Quantiles(String jobId, Date timestamp, String quantileState) {
        this.jobId = jobId;
        this.timestamp = Objects.requireNonNull(timestamp);
        this.quantileState = Objects.requireNonNull(quantileState);
    }

    public Quantiles(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.timestamp = new Date(in.readVLong());
        this.quantileState = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeVLong(this.timestamp.getTime());
        out.writeOptionalString(this.quantileState);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (this.timestamp != null) {
            builder.field(TIMESTAMP.getPreferredName(), this.timestamp.getTime());
        }
        if (this.quantileState != null) {
            builder.field(QUANTILE_STATE.getPreferredName(), this.quantileState);
        }
        builder.endObject();
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getQuantileState() {
        return this.quantileState;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.timestamp, this.quantileState);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Quantiles)) {
            return false;
        }
        Quantiles that = (Quantiles)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.quantileState, that.quantileState);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> new Date(p.longValue()), TIMESTAMP, ObjectParser.ValueType.LONG);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), QUANTILE_STATE);
    }
}

