/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.ClientHelper;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.CategorizerState;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.Quantiles;

public class JobStorageDeletionTask
extends Task {
    private final Logger logger = Loggers.getLogger(((Object)((Object)this)).getClass());

    public JobStorageDeletionTask(long id, String type, String action, String description, TaskId parentTask) {
        super(id, type, action, description, parentTask);
    }

    public void delete(String jobId, Client client, ClusterState state, CheckedConsumer<Boolean, Exception> finishedHandler, Consumer<Exception> failureHandler) {
        String indexName = AnomalyDetectorsIndex.getPhysicalIndexFromState(state, jobId);
        String indexPattern = indexName + "-*";
        ActionListener deleteAliasHandler = ActionListener.wrap(finishedHandler, failureHandler);
        ActionListener dbqHandler = ActionListener.wrap(bulkByScrollResponse -> {
            if (bulkByScrollResponse.isTimedOut()) {
                this.logger.warn("[{}] DeleteByQuery for indices [{}, {}] timed out.", (Object)jobId, (Object)indexName, (Object)indexPattern);
            }
            if (!bulkByScrollResponse.getBulkFailures().isEmpty()) {
                this.logger.warn("[{}] {} failures and {} conflicts encountered while running DeleteByQuery on indices [{}, {}].", (Object)jobId, (Object)bulkByScrollResponse.getBulkFailures().size(), (Object)bulkByScrollResponse.getVersionConflicts(), (Object)indexName, (Object)indexPattern);
                for (BulkItemResponse.Failure failure : bulkByScrollResponse.getBulkFailures()) {
                    this.logger.warn("DBQ failure: " + failure);
                }
            }
            this.deleteAliases(jobId, client, (ActionListener<Boolean>)deleteAliasHandler);
        }, failureHandler);
        ActionListener deleteCategorizerStateHandler = ActionListener.wrap(response -> {
            this.logger.info("Running DBQ on [" + indexName + "," + indexPattern + "] for job [" + jobId + "]");
            SearchRequest searchRequest = new SearchRequest(new String[]{indexName, indexPattern});
            DeleteByQueryRequest request = new DeleteByQueryRequest(searchRequest);
            ConstantScoreQueryBuilder query = new ConstantScoreQueryBuilder((QueryBuilder)new TermQueryBuilder(Job.ID.getPreferredName(), jobId));
            searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)query));
            searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(IndicesOptions.lenientExpandOpen()));
            request.setSlices(5);
            request.setAbortOnVersionConflict(false);
            request.setRefresh(true);
            ClientHelper.executeAsyncWithOrigin(client, "ml", DeleteByQueryAction.INSTANCE, request, dbqHandler);
        }, failureHandler);
        ActionListener deleteQuantilesHandler = ActionListener.wrap(response -> this.deleteCategorizerState(jobId, client, 1, (ActionListener<Boolean>)deleteCategorizerStateHandler), failureHandler);
        ActionListener deleteStateHandler = ActionListener.wrap(bulkResponse -> this.deleteQuantiles(jobId, client, (ActionListener<Boolean>)deleteQuantilesHandler), failureHandler);
        this.deleteModelState(jobId, client, (ActionListener<BulkResponse>)deleteStateHandler);
    }

    private void deleteQuantiles(String jobId, Client client, ActionListener<Boolean> finishedHandler) {
        SearchRequest searchRequest = new SearchRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexName()});
        DeleteByQueryRequest request = new DeleteByQueryRequest(searchRequest);
        IdsQueryBuilder query = new IdsQueryBuilder().addIds(new String[]{Quantiles.documentId(jobId), Quantiles.v54DocumentId(jobId)});
        searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)query));
        searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(IndicesOptions.lenientExpandOpen()));
        request.setAbortOnVersionConflict(false);
        request.setRefresh(true);
        ClientHelper.executeAsyncWithOrigin(client, "ml", DeleteByQueryAction.INSTANCE, request, ActionListener.wrap(response -> finishedHandler.onResponse((Object)true), e -> {
            if (e instanceof IndexNotFoundException) {
                finishedHandler.onResponse((Object)true);
            } else {
                finishedHandler.onFailure(e);
            }
        }));
    }

    private void deleteModelState(String jobId, Client client, ActionListener<BulkResponse> listener) {
        JobProvider jobProvider = new JobProvider(client, Settings.EMPTY);
        jobProvider.modelSnapshots(jobId, 0, 10000, page -> {
            List<ModelSnapshot> deleteCandidates = page.results();
            JobDataDeleter deleter = new JobDataDeleter(client, jobId);
            deleter.deleteModelSnapshots(deleteCandidates, listener);
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private void deleteCategorizerState(String jobId, Client client, int docNum, ActionListener<Boolean> finishedHandler) {
        SearchRequest searchRequest = new SearchRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexName()});
        DeleteByQueryRequest request = new DeleteByQueryRequest(searchRequest);
        IdsQueryBuilder query = new IdsQueryBuilder().addIds(new String[]{CategorizerState.documentId(jobId, docNum), CategorizerState.v54DocumentId(jobId, docNum)});
        searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)query));
        searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(IndicesOptions.lenientExpandOpen()));
        request.setAbortOnVersionConflict(false);
        request.setRefresh(true);
        ClientHelper.executeAsyncWithOrigin(client, "ml", DeleteByQueryAction.INSTANCE, request, ActionListener.wrap(response -> {
            if (response.getDeleted() > 0L) {
                this.deleteCategorizerState(jobId, client, docNum + 1, finishedHandler);
                return;
            }
            finishedHandler.onResponse((Object)true);
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                finishedHandler.onResponse((Object)true);
            } else {
                finishedHandler.onFailure(e);
            }
        }));
    }

    private void deleteAliases(String jobId, Client client, ActionListener<Boolean> finishedHandler) {
        String readAliasName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        String writeAliasName = AnomalyDetectorsIndex.resultsWriteAlias(jobId);
        GetAliasesRequest aliasesRequest = new GetAliasesRequest().aliases(new String[]{readAliasName, writeAliasName}).indicesOptions(IndicesOptions.lenientExpandOpen());
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", aliasesRequest, ActionListener.wrap(getAliasesResponse -> {
            IndicesAliasesRequest removeRequest = this.buildRemoveAliasesRequest((GetAliasesResponse)getAliasesResponse);
            if (removeRequest == null) {
                finishedHandler.onResponse((Object)true);
                return;
            }
            ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", removeRequest, ActionListener.wrap(removeResponse -> finishedHandler.onResponse((Object)true), arg_0 -> ((ActionListener)finishedHandler).onFailure(arg_0)), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).aliases(arg_0, arg_1));
        }, arg_0 -> finishedHandler.onFailure(arg_0)), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).getAliases(arg_0, arg_1));
    }

    private IndicesAliasesRequest buildRemoveAliasesRequest(GetAliasesResponse getAliasesResponse) {
        HashSet aliases = new HashSet();
        ArrayList<Object> indices = new ArrayList<Object>();
        for (ObjectObjectCursor entry : getAliasesResponse.getAliases()) {
            if (((List)entry.value).isEmpty()) continue;
            indices.add(entry.key);
            ((List)entry.value).forEach(metadata -> aliases.add(metadata.getAlias()));
        }
        return aliases.isEmpty() ? null : new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.remove().aliases(aliases.toArray(new String[aliases.size()])).indices(indices.toArray(new String[indices.size()])));
    }
}

