/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.groups;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ml.job.config.Job;

interface GroupOrJob {
    public boolean isGroup();

    public List<Job> jobs();

    public static final class SingleJob
    implements GroupOrJob {
        private final Job job;

        SingleJob(Job job) {
            this.job = Objects.requireNonNull(job);
        }

        @Override
        public boolean isGroup() {
            return false;
        }

        @Override
        public List<Job> jobs() {
            return Collections.singletonList(this.job);
        }
    }

    public static final class Group
    implements GroupOrJob {
        private final List<Job> jobs;

        Group(List<Job> jobs) {
            this.jobs = Collections.unmodifiableList(jobs);
        }

        @Override
        public boolean isGroup() {
            return true;
        }

        @Override
        public List<Job> jobs() {
            return this.jobs;
        }
    }
}

