/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.action.OpenJobAction;
import org.elasticsearch.xpack.ml.action.TransportJobTaskAction;
import org.elasticsearch.xpack.ml.job.config.JobUpdate;
import org.elasticsearch.xpack.ml.job.config.ModelPlotConfig;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;

public class UpdateProcessAction
extends Action<Request, Response, RequestBuilder> {
    public static final UpdateProcessAction INSTANCE = new UpdateProcessAction();
    public static final String NAME = "cluster:internal/xpack/ml/job/update/process";

    private UpdateProcessAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends TransportJobTaskAction<Request, Response> {
        @Inject
        public TransportAction(Settings settings, TransportService transportService, ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutodetectProcessManager processManager) {
            super(settings, UpdateProcessAction.NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, () -> new Response(), "same", processManager);
        }

        protected Response readTaskResponse(StreamInput in) throws IOException {
            Response response = new Response();
            response.readFrom(in);
            return response;
        }

        protected void taskOperation(Request request, OpenJobAction.JobTask task, ActionListener<Response> listener) {
            try {
                this.processManager.writeUpdateProcessMessage(task, request.getDetectorUpdates(), request.getModelPlotConfig(), e -> {
                    if (e == null) {
                        listener.onResponse((Object)new Response());
                    } else {
                        listener.onFailure(e);
                    }
                });
            }
            catch (Exception e2) {
                listener.onFailure(e2);
            }
        }
    }

    public static class Request
    extends TransportJobTaskAction.JobTaskRequest<Request> {
        private ModelPlotConfig modelPlotConfig;
        private List<JobUpdate.DetectorUpdate> detectorUpdates;

        Request() {
        }

        public Request(String jobId, ModelPlotConfig modelPlotConfig, List<JobUpdate.DetectorUpdate> detectorUpdates) {
            super(jobId);
            this.modelPlotConfig = modelPlotConfig;
            this.detectorUpdates = detectorUpdates;
        }

        public ModelPlotConfig getModelPlotConfig() {
            return this.modelPlotConfig;
        }

        public List<JobUpdate.DetectorUpdate> getDetectorUpdates() {
            return this.detectorUpdates;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.modelPlotConfig = (ModelPlotConfig)in.readOptionalWriteable(ModelPlotConfig::new);
            if (in.readBoolean()) {
                this.detectorUpdates = in.readList(JobUpdate.DetectorUpdate::new);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalWriteable((Writeable)this.modelPlotConfig);
            boolean hasDetectorUpdates = this.detectorUpdates != null;
            out.writeBoolean(hasDetectorUpdates);
            if (hasDetectorUpdates) {
                out.writeList(this.detectorUpdates);
            }
        }

        public int hashCode() {
            return Objects.hash(this.getJobId(), this.modelPlotConfig, this.detectorUpdates);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.getJobId(), other.getJobId()) && Objects.equals(this.modelPlotConfig, other.modelPlotConfig) && Objects.equals(this.detectorUpdates, other.detectorUpdates);
        }
    }

    public static class Response
    extends BaseTasksResponse
    implements StatusToXContentObject,
    Writeable {
        private boolean isUpdated = true;

        private Response() {
            super(null, null);
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.isUpdated = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.isUpdated);
        }

        public boolean isUpdated() {
            return this.isUpdated;
        }

        public RestStatus status() {
            return RestStatus.ACCEPTED;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("updated", this.isUpdated);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hashCode(this.isUpdated);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return this.isUpdated == other.isUpdated;
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, UpdateProcessAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }
}

