/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.action.OpenJobAction;
import org.elasticsearch.xpack.ml.action.TransportJobTaskAction;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.notifications.Auditor;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;

public class KillProcessAction
extends Action<Request, Response, RequestBuilder> {
    public static final KillProcessAction INSTANCE = new KillProcessAction();
    public static final String NAME = "cluster:internal/xpack/ml/job/kill/process";

    private KillProcessAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends TransportJobTaskAction<Request, Response> {
        private final Auditor auditor;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutodetectProcessManager processManager, Auditor auditor) {
            super(settings, KillProcessAction.NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, Response::new, "ml_utility", processManager);
            this.auditor = auditor;
        }

        protected void taskOperation(Request request, OpenJobAction.JobTask jobTask, ActionListener<Response> listener) {
            this.logger.info("[{}] Killing job", (Object)jobTask.getJobId());
            this.auditor.info(jobTask.getJobId(), "Killing job");
            try {
                this.processManager.killProcess(jobTask, true, null);
                listener.onResponse((Object)new Response(true));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }

        @Override
        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            DiscoveryNodes nodes = this.clusterService.state().nodes();
            PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)this.clusterService.state().getMetaData().custom("persistent_tasks");
            PersistentTasksCustomMetaData.PersistentTask<?> jobTask = MlMetadata.getJobTask(request.getJobId(), tasks);
            if (jobTask == null || jobTask.getExecutorNode() == null) {
                this.logger.debug("[{}] Cannot kill the process because job is not open", (Object)request.getJobId());
                listener.onResponse((Object)new Response(false));
                return;
            }
            DiscoveryNode executorNode = nodes.get(jobTask.getExecutorNode());
            if (executorNode == null) {
                listener.onFailure((Exception)ExceptionsHelper.conflictStatusException("Cannot kill process for job {} asexecutor node {} cannot be found", request.getJobId(), jobTask.getExecutorNode()));
                return;
            }
            Version nodeVersion = executorNode.getVersion();
            if (nodeVersion.before(Version.V_5_5_0)) {
                listener.onFailure((Exception)new ElasticsearchException("Cannot kill the process on node with version " + nodeVersion, new Object[0]));
                return;
            }
            super.doExecute(task, request, listener);
        }

        protected Response readTaskResponse(StreamInput in) throws IOException {
            return new Response(in);
        }
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable {
        private boolean killed;

        Response() {
            super(null, null);
        }

        Response(StreamInput in) throws IOException {
            super(null, null);
            this.readFrom(in);
        }

        Response(boolean killed) {
            super(null, null);
            this.killed = killed;
        }

        public boolean isKilled() {
            return this.killed;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.killed = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.killed);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.killed == response.killed;
        }

        public int hashCode() {
            return Objects.hash(this.killed);
        }
    }

    public static class Request
    extends TransportJobTaskAction.JobTaskRequest<Request> {
        public Request(String jobId) {
            super(jobId);
        }

        Request() {
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, KillProcessAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }
}

