/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.action.util.QueryPage;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;

public class GetJobsAction
extends Action<Request, Response, RequestBuilder> {
    public static final GetJobsAction INSTANCE = new GetJobsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/job/get";

    private GetJobsAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends TransportMasterNodeReadAction<Request, Response> {
        private final JobManager jobManager;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobManager jobManager) {
            super(settings, GetJobsAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
            this.jobManager = jobManager;
        }

        protected String executor() {
            return "same";
        }

        protected Response newResponse() {
            return new Response();
        }

        protected void masterOperation(Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
            this.logger.debug("Get job '{}'", (Object)request.getJobId());
            QueryPage<Job> jobs = this.jobManager.expandJobs(request.getJobId(), request.allowNoJobs(), state);
            listener.onResponse((Object)new Response(jobs));
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private QueryPage<Job> jobs;

        public Response(QueryPage<Job> jobs) {
            this.jobs = jobs;
        }

        public Response() {
        }

        public QueryPage<Job> getResponse() {
            return this.jobs;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobs = new QueryPage(in, Job::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.jobs.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.jobs.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobs);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.jobs, other.jobs);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public static class RequestBuilder
    extends MasterNodeReadOperationRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, GetJobsAction action) {
            super(client, (Action)action, (MasterNodeReadRequest)new Request());
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        public static final ParseField ALLOW_NO_JOBS = new ParseField("allow_no_jobs", new String[0]);
        private String jobId;
        private boolean allowNoJobs = true;

        public Request(String jobId) {
            this();
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        Request() {
            this.local(true);
        }

        public void setAllowNoJobs(boolean allowNoJobs) {
            this.allowNoJobs = allowNoJobs;
        }

        public String getJobId() {
            return this.jobId;
        }

        public boolean allowNoJobs() {
            return this.allowNoJobs;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
                this.allowNoJobs = in.readBoolean();
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
                out.writeBoolean(this.allowNoJobs);
            }
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.allowNoJobs);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.allowNoJobs, other.allowNoJobs);
        }
    }
}

