/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.action.util.QueryPage;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;

public class GetDatafeedsStatsAction
extends Action<Request, Response, RequestBuilder> {
    public static final GetDatafeedsStatsAction INSTANCE = new GetDatafeedsStatsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/datafeeds/stats/get";
    public static final String ALL = "_all";
    private static final String STATE = "state";

    private GetDatafeedsStatsAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends TransportMasterNodeReadAction<Request, Response> {
        @Inject
        public TransportAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(settings, GetDatafeedsStatsAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
        }

        protected String executor() {
            return "same";
        }

        protected Response newResponse() {
            return new Response();
        }

        protected void masterOperation(Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
            this.logger.debug("Get stats for datafeed '{}'", (Object)request.getDatafeedId());
            MlMetadata mlMetadata = (MlMetadata)state.metaData().custom("ml");
            if (mlMetadata == null) {
                mlMetadata = MlMetadata.EMPTY_METADATA;
            }
            Set<String> expandedDatafeedIds = mlMetadata.expandDatafeedIds(request.getDatafeedId(), request.allowNoDatafeeds());
            PersistentTasksCustomMetaData tasksInProgress = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
            List results = expandedDatafeedIds.stream().map(datafeedId -> TransportAction.getDatafeedStats(datafeedId, state, tasksInProgress)).collect(Collectors.toList());
            QueryPage<Response.DatafeedStats> statsPage = new QueryPage<Response.DatafeedStats>(results, results.size(), DatafeedConfig.RESULTS_FIELD);
            listener.onResponse((Object)new Response(statsPage));
        }

        private static Response.DatafeedStats getDatafeedStats(String datafeedId, ClusterState state, PersistentTasksCustomMetaData tasks) {
            PersistentTasksCustomMetaData.PersistentTask<?> task = MlMetadata.getDatafeedTask(datafeedId, tasks);
            DatafeedState datafeedState = MlMetadata.getDatafeedState(datafeedId, tasks);
            DiscoveryNode node = null;
            String explanation = null;
            if (task != null) {
                node = state.nodes().get(task.getExecutorNode());
                explanation = task.getAssignment().getExplanation();
            }
            return new Response.DatafeedStats(datafeedId, datafeedState, node, explanation);
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private QueryPage<DatafeedStats> datafeedsStats;

        public Response(QueryPage<DatafeedStats> datafeedsStats) {
            this.datafeedsStats = datafeedsStats;
        }

        public Response() {
        }

        public QueryPage<DatafeedStats> getResponse() {
            return this.datafeedsStats;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.datafeedsStats = new QueryPage(in, DatafeedStats::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.datafeedsStats.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.datafeedsStats.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.datafeedsStats);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.datafeedsStats, other.datafeedsStats);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }

        public static class DatafeedStats
        implements ToXContentObject,
        Writeable {
            private final String datafeedId;
            private final DatafeedState datafeedState;
            @Nullable
            private DiscoveryNode node;
            @Nullable
            private String assignmentExplanation;

            DatafeedStats(String datafeedId, DatafeedState datafeedState, @Nullable DiscoveryNode node, @Nullable String assignmentExplanation) {
                this.datafeedId = Objects.requireNonNull(datafeedId);
                this.datafeedState = Objects.requireNonNull(datafeedState);
                this.node = node;
                this.assignmentExplanation = assignmentExplanation;
            }

            DatafeedStats(StreamInput in) throws IOException {
                this.datafeedId = in.readString();
                this.datafeedState = DatafeedState.fromStream(in);
                this.node = (DiscoveryNode)in.readOptionalWriteable(DiscoveryNode::new);
                this.assignmentExplanation = in.readOptionalString();
            }

            public String getDatafeedId() {
                return this.datafeedId;
            }

            public DatafeedState getDatafeedState() {
                return this.datafeedState;
            }

            public DiscoveryNode getNode() {
                return this.node;
            }

            public String getAssignmentExplanation() {
                return this.assignmentExplanation;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(DatafeedConfig.ID.getPreferredName(), this.datafeedId);
                builder.field(GetDatafeedsStatsAction.STATE, this.datafeedState.toString());
                if (this.node != null) {
                    builder.startObject("node");
                    builder.field("id", this.node.getId());
                    builder.field("name", this.node.getName());
                    builder.field("ephemeral_id", this.node.getEphemeralId());
                    builder.field("transport_address", this.node.getAddress().toString());
                    builder.startObject("attributes");
                    for (Map.Entry entry : this.node.getAttributes().entrySet()) {
                        builder.field((String)entry.getKey(), (String)entry.getValue());
                    }
                    builder.endObject();
                    builder.endObject();
                }
                if (this.assignmentExplanation != null) {
                    builder.field("assignment_explanation", this.assignmentExplanation);
                }
                builder.endObject();
                return builder;
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.datafeedId);
                this.datafeedState.writeTo(out);
                out.writeOptionalWriteable((Writeable)this.node);
                out.writeOptionalString(this.assignmentExplanation);
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.datafeedId, this.datafeedState, this.node, this.assignmentExplanation});
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                DatafeedStats other = (DatafeedStats)obj;
                return Objects.equals(this.datafeedId, other.datafeedId) && Objects.equals((Object)this.datafeedState, (Object)other.datafeedState) && Objects.equals(this.node, other.node) && Objects.equals(this.assignmentExplanation, other.assignmentExplanation);
            }
        }
    }

    public static class RequestBuilder
    extends MasterNodeReadOperationRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, GetDatafeedsStatsAction action) {
            super(client, (Action)action, (MasterNodeReadRequest)new Request());
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        public static final ParseField ALLOW_NO_DATAFEEDS = new ParseField("allow_no_datafeeds", new String[0]);
        private String datafeedId;
        private boolean allowNoDatafeeds = true;

        public Request(String datafeedId) {
            this.datafeedId = ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID.getPreferredName());
        }

        Request() {
        }

        public String getDatafeedId() {
            return this.datafeedId;
        }

        public boolean allowNoDatafeeds() {
            return this.allowNoDatafeeds;
        }

        public void setAllowNoDatafeeds(boolean allowNoDatafeeds) {
            this.allowNoDatafeeds = allowNoDatafeeds;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.datafeedId = in.readString();
            if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
                this.allowNoDatafeeds = in.readBoolean();
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.datafeedId);
            if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
                out.writeBoolean(this.allowNoDatafeeds);
            }
        }

        public int hashCode() {
            return Objects.hash(this.datafeedId, this.allowNoDatafeeds);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.datafeedId, other.datafeedId) && Objects.equals(this.allowNoDatafeeds, other.allowNoDatafeeds);
        }
    }
}

