/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Date;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.job.config.Job;

public class FinalizeJobExecutionAction
extends Action<Request, Response, RequestBuilder> {
    public static final FinalizeJobExecutionAction INSTANCE = new FinalizeJobExecutionAction();
    public static final String NAME = "cluster:internal/xpack/ml/job/finalize_job_execution";

    private FinalizeJobExecutionAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, INSTANCE);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, Response> {
        @Inject
        public TransportAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(settings, FinalizeJobExecutionAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
        }

        protected String executor() {
            return "same";
        }

        protected Response newResponse() {
            return new Response();
        }

        protected void masterOperation(final Request request, ClusterState state, final ActionListener<Response> listener) throws Exception {
            final String jobIdString = String.join((CharSequence)",", request.getJobIds());
            String source = "finalize_job_execution [" + jobIdString + "]";
            this.logger.debug("finalizing jobs [{}]", (Object)jobIdString);
            this.clusterService.submitStateUpdateTask(source, (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

                public ClusterState execute(ClusterState currentState) throws Exception {
                    MlMetadata mlMetadata = (MlMetadata)currentState.metaData().custom("ml");
                    MlMetadata.Builder mlMetadataBuilder = new MlMetadata.Builder(mlMetadata);
                    Date finishedTime = new Date();
                    for (String jobId : request.getJobIds()) {
                        Job.Builder jobBuilder = new Job.Builder(mlMetadata.getJobs().get(jobId));
                        jobBuilder.setFinishedTime(finishedTime);
                        mlMetadataBuilder.putJob(jobBuilder.build(), true);
                    }
                    ClusterState.Builder builder = ClusterState.builder((ClusterState)currentState);
                    return builder.metaData(new MetaData.Builder(currentState.metaData()).putCustom("ml", (MetaData.Custom)mlMetadataBuilder.build())).build();
                }

                public void onFailure(String source, Exception e) {
                    listener.onFailure(e);
                }

                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    logger.debug("finalized job [{}]", (Object)jobIdString);
                    listener.onResponse((Object)new Response(true));
                }
            });
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }
    }

    public static class Response
    extends AcknowledgedResponse {
        Response(boolean acknowledged) {
            super(acknowledged);
        }

        Response() {
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.readAcknowledged(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.writeAcknowledged(out);
        }
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, FinalizeJobExecutionAction action) {
            super(client, (Action)action, (MasterNodeRequest)new Request());
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private String[] jobIds;

        public Request(String[] jobIds) {
            this.jobIds = jobIds;
        }

        Request() {
        }

        public String[] getJobIds() {
            return this.jobIds;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobIds = in.readStringArray();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.jobIds);
        }

        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

