/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ClientHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.action.KillProcessAction;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.persistence.JobStorageDeletionTask;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.xpack.persistent.PersistentTasksService;

public class DeleteJobAction
extends Action<Request, Response, RequestBuilder> {
    public static final DeleteJobAction INSTANCE = new DeleteJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/delete";

    private DeleteJobAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, Response> {
        private final Client client;
        private final JobManager jobManager;
        private final PersistentTasksService persistentTasksService;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobManager jobManager, PersistentTasksService persistentTasksService, Client client) {
            super(settings, DeleteJobAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
            this.client = client;
            this.jobManager = jobManager;
            this.persistentTasksService = persistentTasksService;
        }

        protected String executor() {
            return "same";
        }

        protected Response newResponse() {
            return new Response();
        }

        protected void masterOperation(Task task, Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
            ActionListener markAsDeletingListener = ActionListener.wrap(response -> {
                if (request.isForce()) {
                    this.forceDeleteJob(request, (JobStorageDeletionTask)task, listener);
                } else {
                    this.normalDeleteJob(request, (JobStorageDeletionTask)task, listener);
                }
            }, e -> {
                if (e instanceof MlMetadata.JobAlreadyMarkedAsDeletedException) {
                    this.waitForDeletingJob(request.getJobId(), MachineLearning.STATE_PERSIST_RESTORE_TIMEOUT, (ActionListener<Response>)ActionListener.wrap(arg_0 -> ((ActionListener)listener).onResponse(arg_0), e2 -> {
                        if (request.isForce() && e2 instanceof TimeoutException) {
                            this.forceDeleteJob(request, (JobStorageDeletionTask)task, listener);
                        } else {
                            listener.onFailure(e2);
                        }
                    }));
                } else {
                    listener.onFailure(e);
                }
            });
            this.markJobAsDeleting(request.getJobId(), (ActionListener<Boolean>)markAsDeletingListener, request.isForce());
        }

        protected void masterOperation(Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
            throw new UnsupportedOperationException("the Task parameter is required");
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        private void normalDeleteJob(Request request, JobStorageDeletionTask task, ActionListener<Response> listener) {
            this.jobManager.deleteJob(request, task, listener);
        }

        private void forceDeleteJob(final Request request, final JobStorageDeletionTask task, final ActionListener<Response> listener) {
            ClusterState state = this.clusterService.state();
            String jobId = request.getJobId();
            ActionListener<Boolean> removeTaskListener = new ActionListener<Boolean>(){

                public void onResponse(Boolean response) {
                    jobManager.deleteJob(request, task, (ActionListener<Response>)listener);
                }

                public void onFailure(Exception e) {
                    if (e instanceof ResourceNotFoundException) {
                        jobManager.deleteJob(request, task, (ActionListener<Response>)listener);
                    } else {
                        listener.onFailure(e);
                    }
                }
            };
            ActionListener killJobListener = ActionListener.wrap(arg_0 -> this.lambda$forceDeleteJob$3(request, state, (ActionListener)removeTaskListener, arg_0), arg_0 -> this.lambda$forceDeleteJob$4(request, state, (ActionListener)removeTaskListener, listener, arg_0));
            this.killProcess(jobId, (ActionListener<KillProcessAction.Response>)killJobListener);
        }

        private void killProcess(String jobId, ActionListener<KillProcessAction.Response> listener) {
            KillProcessAction.Request killRequest = new KillProcessAction.Request(jobId);
            ClientHelper.executeAsyncWithOrigin(this.client, "ml", KillProcessAction.INSTANCE, killRequest, listener);
        }

        private void removePersistentTask(String jobId, ClusterState currentState, final ActionListener<Boolean> listener) {
            PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)currentState.getMetaData().custom("persistent_tasks");
            PersistentTasksCustomMetaData.PersistentTask<?> jobTask = MlMetadata.getJobTask(jobId, tasks);
            if (jobTask == null) {
                listener.onResponse(null);
            } else {
                this.persistentTasksService.cancelPersistentTask(jobTask.getId(), new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

                    public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> task) {
                        listener.onResponse((Object)Boolean.TRUE);
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }
        }

        void markJobAsDeleting(final String jobId, final ActionListener<Boolean> listener, final boolean force) {
            this.clusterService.submitStateUpdateTask("mark-job-as-deleted", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

                public ClusterState execute(ClusterState currentState) throws Exception {
                    MlMetadata currentMlMetadata = (MlMetadata)currentState.metaData().custom("ml");
                    PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)currentState.metaData().custom("persistent_tasks");
                    MlMetadata.Builder builder = new MlMetadata.Builder(currentMlMetadata);
                    builder.markJobAsDeleted(jobId, tasks, force);
                    return TransportAction.buildNewClusterState(currentState, builder);
                }

                public void onFailure(String source, Exception e) {
                    listener.onFailure(e);
                }

                public void clusterStatePublished(ClusterChangedEvent clusterChangedEvent) {
                    logger.debug("Job [" + jobId + "] is successfully marked as deleted");
                    listener.onResponse((Object)true);
                }
            });
        }

        void waitForDeletingJob(String jobId, TimeValue timeout, final ActionListener<Response> listener) {
            ClusterStateObserver stateObserver = new ClusterStateObserver(this.clusterService, timeout, this.logger, this.threadPool.getThreadContext());
            ClusterState clusterState = stateObserver.setAndGetObservedState();
            if (TransportAction.jobIsDeletedFromState(jobId, clusterState)) {
                listener.onResponse((Object)new Response(true));
            } else {
                stateObserver.waitForNextChange(new ClusterStateObserver.Listener(){

                    public void onNewClusterState(ClusterState state) {
                        listener.onResponse((Object)new Response(true));
                    }

                    public void onClusterServiceClose() {
                        listener.onFailure((Exception)new NodeClosedException(clusterService.localNode()));
                    }

                    public void onTimeout(TimeValue timeout) {
                        listener.onFailure((Exception)new TimeoutException("timed out after " + timeout));
                    }
                }, newClusterState -> TransportAction.jobIsDeletedFromState(jobId, newClusterState), timeout);
            }
        }

        static boolean jobIsDeletedFromState(String jobId, ClusterState clusterState) {
            MlMetadata metadata = (MlMetadata)clusterState.metaData().custom("ml");
            if (metadata == null) {
                return true;
            }
            return !metadata.getJobs().containsKey(jobId);
        }

        private static ClusterState buildNewClusterState(ClusterState currentState, MlMetadata.Builder builder) {
            ClusterState.Builder newState = ClusterState.builder((ClusterState)currentState);
            newState.metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("ml", (MetaData.Custom)builder.build()).build());
            return newState.build();
        }

        private /* synthetic */ void lambda$forceDeleteJob$4(Request request, ClusterState state, ActionListener removeTaskListener, ActionListener listener, Exception e) {
            if (e instanceof ElasticsearchStatusException) {
                this.removePersistentTask(request.getJobId(), state, (ActionListener<Boolean>)removeTaskListener);
            } else {
                listener.onFailure(e);
            }
        }

        private /* synthetic */ void lambda$forceDeleteJob$3(Request request, ClusterState state, ActionListener removeTaskListener, KillProcessAction.Response response) throws Exception {
            this.removePersistentTask(request.getJobId(), state, (ActionListener<Boolean>)removeTaskListener);
        }
    }

    public static class Response
    extends AcknowledgedResponse {
        public Response(boolean acknowledged) {
            super(acknowledged);
        }

        private Response() {
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.readAcknowledged(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.writeAcknowledged(out);
        }
    }

    static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, DeleteJobAction action) {
            super(client, (Action)action, (MasterNodeRequest)new Request());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private String jobId;
        private boolean force;

        public Request(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        Request() {
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public boolean isForce() {
            return this.force;
        }

        public void setForce(boolean force) {
            this.force = force;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId) {
            return new JobStorageDeletionTask(id, type, action, "delete-job-" + this.jobId, parentTaskId);
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            if (in.getVersion().onOrAfter(Version.V_5_5_0)) {
                this.force = in.readBoolean();
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            if (out.getVersion().onOrAfter(Version.V_5_5_0)) {
                out.writeBoolean(this.force);
            }
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.force);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.force, other.force);
        }
    }
}

