/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.job.retention.ExpiredForecastsRemover;
import org.elasticsearch.xpack.ml.job.retention.ExpiredModelSnapshotsRemover;
import org.elasticsearch.xpack.ml.job.retention.ExpiredResultsRemover;
import org.elasticsearch.xpack.ml.job.retention.MlDataRemover;
import org.elasticsearch.xpack.ml.notifications.Auditor;
import org.elasticsearch.xpack.ml.utils.VolatileCursorIterator;

public class DeleteExpiredDataAction
extends Action<Request, Response, RequestBuilder> {
    public static final DeleteExpiredDataAction INSTANCE = new DeleteExpiredDataAction();
    public static final String NAME = "cluster:admin/xpack/ml/delete_expired_data";

    private DeleteExpiredDataAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final Client client;
        private final ClusterService clusterService;

        @Inject
        public TransportAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, ClusterService clusterService) {
            super(settings, DeleteExpiredDataAction.NAME, threadPool, transportService, actionFilters, indexNameExpressionResolver, Request::new);
            this.client = client;
            this.clusterService = clusterService;
        }

        protected void doExecute(Request request, ActionListener<Response> listener) {
            this.logger.info("Deleting expired data");
            this.threadPool.executor("ml_utility").execute(() -> this.deleteExpiredData(listener));
        }

        private void deleteExpiredData(ActionListener<Response> listener) {
            Auditor auditor = new Auditor(this.client, this.clusterService);
            List<MlDataRemover> dataRemovers = Arrays.asList(new ExpiredResultsRemover(this.client, this.clusterService, auditor), new ExpiredForecastsRemover(this.client), new ExpiredModelSnapshotsRemover(this.client, this.clusterService));
            VolatileCursorIterator<MlDataRemover> dataRemoversIterator = new VolatileCursorIterator<MlDataRemover>(dataRemovers);
            this.deleteExpiredData(dataRemoversIterator, listener);
        }

        private void deleteExpiredData(Iterator<MlDataRemover> mlDataRemoversIterator, ActionListener<Response> listener) {
            if (mlDataRemoversIterator.hasNext()) {
                MlDataRemover remover = mlDataRemoversIterator.next();
                remover.remove((ActionListener<Boolean>)ActionListener.wrap(booleanResponse -> this.deleteExpiredData(mlDataRemoversIterator, listener), arg_0 -> listener.onFailure(arg_0)));
            } else {
                this.logger.info("Completed deletion of expired data");
                listener.onResponse((Object)new Response(true));
            }
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private static final ParseField DELETED = new ParseField("deleted", new String[0]);
        private boolean deleted;

        public Response(boolean deleted) {
            this.deleted = deleted;
        }

        Response() {
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.deleted = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.deleted);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(DELETED.getPreferredName(), this.deleted);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.deleted, response.deleted);
        }

        public int hashCode() {
            return Objects.hash(this.deleted);
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, DeleteExpiredDataAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest {
        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

