/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.action.OpenJobAction;
import org.elasticsearch.xpack.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.notifications.Auditor;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;

public class MlAssignmentNotifier
extends AbstractComponent
implements ClusterStateListener,
LocalNodeMasterListener {
    private final Auditor auditor;
    private final ClusterService clusterService;
    private final AtomicBoolean enabled = new AtomicBoolean(false);

    MlAssignmentNotifier(Settings settings, Auditor auditor, ClusterService clusterService) {
        super(settings);
        this.auditor = auditor;
        this.clusterService = clusterService;
        clusterService.addLocalNodeMasterListener((LocalNodeMasterListener)this);
    }

    public void onMaster() {
        if (this.enabled.compareAndSet(false, true)) {
            this.clusterService.addListener((ClusterStateListener)this);
        }
    }

    public void offMaster() {
        if (this.enabled.compareAndSet(true, false)) {
            this.clusterService.removeListener((ClusterStateListener)this);
        }
    }

    public String executorName() {
        return "generic";
    }

    public void clusterChanged(ClusterChangedEvent event) {
        PersistentTasksCustomMetaData current;
        if (!this.enabled.get()) {
            return;
        }
        if (!event.metaDataChanged()) {
            return;
        }
        PersistentTasksCustomMetaData previous = (PersistentTasksCustomMetaData)event.previousState().getMetaData().custom("persistent_tasks");
        if (Objects.equals((Object)previous, (Object)(current = (PersistentTasksCustomMetaData)event.state().getMetaData().custom("persistent_tasks")))) {
            return;
        }
        for (PersistentTasksCustomMetaData.PersistentTask<?> currentTask : current.tasks()) {
            PersistentTasksCustomMetaData.PersistentTask<?> previousTask;
            PersistentTasksCustomMetaData.Assignment previousAssignment;
            PersistentTasksCustomMetaData.Assignment currentAssignment = currentTask.getAssignment();
            if (Objects.equals(currentAssignment, previousAssignment = (previousTask = previous != null ? previous.getTask(currentTask.getId()) : null) != null ? previousTask.getAssignment() : null)) continue;
            if ("xpack/ml/job".equals(currentTask.getTaskName())) {
                String jobId = ((OpenJobAction.JobParams)currentTask.getParams()).getJobId();
                if (currentAssignment.getExecutorNode() == null) {
                    this.auditor.warning(jobId, "No node found to open job. Reasons [" + currentAssignment.getExplanation() + "]");
                    continue;
                }
                DiscoveryNode node = event.state().nodes().get(currentAssignment.getExecutorNode());
                this.auditor.info(jobId, "Opening job on node [" + node.toString() + "]");
                continue;
            }
            if (!"xpack/ml/datafeed".equals(currentTask.getTaskName())) continue;
            String datafeedId = ((StartDatafeedAction.DatafeedParams)currentTask.getParams()).getDatafeedId();
            MlMetadata mlMetadata = (MlMetadata)event.state().getMetaData().custom("ml");
            DatafeedConfig datafeedConfig = mlMetadata.getDatafeed(datafeedId);
            if (currentAssignment.getExecutorNode() == null) {
                String msg = "No node found to start datafeed [" + datafeedId + "]. Reasons [" + currentAssignment.getExplanation() + "]";
                this.logger.warn("[{}] {}", (Object)datafeedConfig.getJobId(), (Object)msg);
                this.auditor.warning(datafeedConfig.getJobId(), msg);
                continue;
            }
            DiscoveryNode node = event.state().nodes().get(currentAssignment.getExecutorNode());
            this.auditor.info(datafeedConfig.getJobId(), "Starting datafeed [" + datafeedId + "] on node [" + node + "]");
        }
    }
}

