/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logstash;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.logstash.LogstashFeatureSet;
import org.elasticsearch.xpack.template.TemplateUtils;

public class Logstash
implements ActionPlugin {
    public static final String NAME = "logstash";
    private static final String LOGSTASH_TEMPLATE_NAME = "logstash-index-template";
    private static final String TEMPLATE_VERSION_PATTERN = Pattern.quote("${logstash.template.version}");
    private final boolean enabled;
    private final boolean transportClientMode;

    public Logstash(Settings settings) {
        this.enabled = (Boolean)XPackSettings.LOGSTASH_ENABLED.get(settings);
        this.transportClientMode = XPackPlugin.transportClientMode(settings);
    }

    boolean isEnabled() {
        return this.enabled;
    }

    boolean isTransportClient() {
        return this.transportClientMode;
    }

    public Collection<Module> nodeModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(b -> XPackPlugin.bindFeatureSet(b, LogstashFeatureSet.class));
        return modules;
    }

    public UnaryOperator<Map<String, IndexTemplateMetaData>> getIndexTemplateMetaDataUpgrader() {
        return templates -> {
            TemplateUtils.loadTemplateIntoMap("/logstash-index-template.json", templates, LOGSTASH_TEMPLATE_NAME, Version.CURRENT.toString(), TEMPLATE_VERSION_PATTERN, Loggers.getLogger(Logstash.class));
            return templates;
        };
    }
}

