/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.xpack.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.IndexDeprecationChecks;

public class DeprecationChecks {
    static List<Function<ClusterState, DeprecationIssue>> CLUSTER_SETTINGS_CHECKS = Collections.unmodifiableList(Arrays.asList(new Function[0]));
    static List<BiFunction<List<NodeInfo>, List<NodeStats>, DeprecationIssue>> NODE_SETTINGS_CHECKS = Collections.unmodifiableList(Arrays.asList(new BiFunction[0]));
    static List<Function<IndexMetaData, DeprecationIssue>> INDEX_SETTINGS_CHECKS = Collections.unmodifiableList(Arrays.asList(IndexDeprecationChecks::allMetaFieldIsDisabledByDefaultCheck, IndexDeprecationChecks::baseSimilarityDefinedCheck, IndexDeprecationChecks::coercionCheck, IndexDeprecationChecks::dynamicTemplateWithMatchMappingTypeCheck, IndexDeprecationChecks::includeInAllCheck, IndexDeprecationChecks::indexSharedFileSystemCheck, IndexDeprecationChecks::indexStoreTypeCheck, IndexDeprecationChecks::storeThrottleSettingsCheck));

    private DeprecationChecks() {
    }

    static <T> List<DeprecationIssue> filterChecks(List<T> checks, Function<T, DeprecationIssue> mapper) {
        return checks.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

