/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.common.unit.ByteSizeValue;

final class SizeLimitInputStream
extends FilterInputStream {
    private final int maxByteSize;
    private final AtomicInteger byteCounter = new AtomicInteger(0);

    SizeLimitInputStream(ByteSizeValue maxByteSize, InputStream in) {
        super(in);
        this.maxByteSize = maxByteSize.bytesAsInt();
    }

    @Override
    public int read() throws IOException {
        this.byteCounter.incrementAndGet();
        this.checkMaximumLengthReached();
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.byteCounter.addAndGet(len);
        this.checkMaximumLengthReached();
        return super.read(b, off, len);
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("mark not supported");
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private void checkMaximumLengthReached() throws IOException {
        if (this.byteCounter.get() > this.maxByteSize) {
            throw new IOException("Maximum limit of [" + this.maxByteSize + "] bytes reached");
        }
    }
}

