/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.http;

import java.util.Locale;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.watcher.support.Exceptions;

public enum HttpContentType {
    JSON{

        @Override
        public XContentType contentType() {
            return XContentType.JSON;
        }
    }
    ,
    YAML{

        @Override
        public XContentType contentType() {
            return XContentType.YAML;
        }
    }
    ,
    TEXT{

        @Override
        public XContentType contentType() {
            return null;
        }
    };


    public abstract XContentType contentType();

    public String toString() {
        return this.id();
    }

    public String id() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static HttpContentType resolve(String id) {
        switch (id.toLowerCase(Locale.ROOT)) {
            case "json": {
                return JSON;
            }
            case "yaml": {
                return YAML;
            }
            case "text": {
                return TEXT;
            }
        }
        throw Exceptions.illegalArgument("unknown http content type [{}]", id);
    }
}

