/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.common.http.HttpMethod;
import org.elasticsearch.xpack.common.http.HttpProxy;
import org.elasticsearch.xpack.common.http.HttpRequest;
import org.elasticsearch.xpack.common.http.HttpResponse;
import org.elasticsearch.xpack.common.http.HttpSettings;
import org.elasticsearch.xpack.common.http.SizeLimitInputStream;
import org.elasticsearch.xpack.common.http.auth.ApplicableHttpAuth;
import org.elasticsearch.xpack.common.http.auth.HttpAuthRegistry;
import org.elasticsearch.xpack.common.socket.SocketAccess;
import org.elasticsearch.xpack.ssl.SSLService;

public class HttpClient
extends AbstractComponent {
    private static final String SETTINGS_SSL_PREFIX = "xpack.http.ssl.";
    private final HttpAuthRegistry httpAuthRegistry;
    private final CloseableHttpClient client;
    private final Integer proxyPort;
    private final String proxyHost;
    private final TimeValue defaultConnectionTimeout;
    private final TimeValue defaultReadTimeout;
    private final ByteSizeValue maxResponseSize;

    public HttpClient(Settings settings, HttpAuthRegistry httpAuthRegistry, SSLService sslService) {
        super(settings);
        this.httpAuthRegistry = httpAuthRegistry;
        this.defaultConnectionTimeout = (TimeValue)HttpSettings.CONNECTION_TIMEOUT.get(settings);
        this.defaultReadTimeout = (TimeValue)HttpSettings.READ_TIMEOUT.get(settings);
        this.maxResponseSize = (ByteSizeValue)HttpSettings.MAX_HTTP_RESPONSE_SIZE.get(settings);
        this.proxyHost = (String)HttpSettings.PROXY_HOST.get(settings);
        this.proxyPort = (Integer)HttpSettings.PROXY_PORT.get(settings);
        if (this.proxyPort != 0 && Strings.hasText((String)this.proxyHost)) {
            this.logger.info("Using default proxy for http input and slack/hipchat/pagerduty/webhook actions [{}:{}]", (Object)this.proxyHost, (Object)this.proxyPort);
        } else if (this.proxyPort != 0 ^ Strings.hasText((String)this.proxyHost)) {
            throw new IllegalArgumentException("HTTP proxy requires both settings: [" + HttpSettings.PROXY_HOST.getKey() + "] and [" + HttpSettings.PROXY_PORT.getKey() + "]");
        }
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        Settings sslSettings = settings.getByPrefix(SETTINGS_SSL_PREFIX);
        boolean isHostnameVerificationEnabled = sslService.getVerificationMode(sslSettings, Settings.EMPTY).isHostnameVerificationEnabled();
        NoopHostnameVerifier verifier = isHostnameVerificationEnabled ? new DefaultHostnameVerifier() : NoopHostnameVerifier.INSTANCE;
        SSLConnectionSocketFactory factory = new SSLConnectionSocketFactory(sslService.sslSocketFactory(sslSettings), (HostnameVerifier)verifier);
        clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)factory);
        this.client = clientBuilder.build();
    }

    public HttpResponse execute(HttpRequest request) throws IOException {
        HttpHost proxy;
        XContentType xContentType;
        Object internalRequest;
        URI uri = this.createURI(request);
        if (request.method == HttpMethod.HEAD) {
            internalRequest = new HttpHead(uri);
        } else {
            HttpMethodWithEntity methodWithEntity = new HttpMethodWithEntity(uri, request.method.name());
            if (request.hasBody()) {
                ByteArrayEntity entity = new ByteArrayEntity(request.body.getBytes(StandardCharsets.UTF_8));
                String string = request.headers().get("Content-Type");
                if (Strings.hasLength((String)string)) {
                    entity.setContentType(string);
                } else {
                    entity.setContentType(ContentType.TEXT_PLAIN.toString());
                }
                methodWithEntity.setEntity((HttpEntity)entity);
            }
            internalRequest = methodWithEntity;
        }
        internalRequest.setHeader("Accept-Charset", StandardCharsets.UTF_8.name());
        RequestConfig.Builder config = RequestConfig.custom();
        if (!request.headers().isEmpty()) {
            for (Map.Entry entry : request.headers.entrySet()) {
                internalRequest.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (request.hasBody() && !internalRequest.containsHeader("Content-Type") && (xContentType = XContentFactory.xContentType((CharSequence)request.body())) != null) {
            internalRequest.setHeader("Content-Type", xContentType.mediaType());
        }
        if (request.proxy != null && !request.proxy.equals(HttpProxy.NO_PROXY)) {
            proxy = new HttpHost(request.proxy.getHost(), request.proxy.getPort().intValue(), request.scheme.scheme());
            config.setProxy(proxy);
        } else if (this.proxyPort != null && Strings.hasText((String)this.proxyHost)) {
            proxy = new HttpHost(this.proxyHost, this.proxyPort.intValue(), request.scheme.scheme());
            config.setProxy(proxy);
        }
        HttpClientContext localContext = HttpClientContext.create();
        if (request.auth() != null) {
            Object AA = this.httpAuthRegistry.createApplicable(request.auth);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            ((ApplicableHttpAuth)AA).apply((CredentialsProvider)credentialsProvider, new AuthScope(request.host, request.port));
            localContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(new HttpHost(request.host, request.port, request.scheme.scheme()), (AuthScheme)basicAuth);
            localContext.setAuthCache((AuthCache)authCache);
        }
        if (request.connectionTimeout() != null) {
            config.setConnectTimeout(Math.toIntExact(request.connectionTimeout.millis()));
        } else {
            config.setConnectTimeout(Math.toIntExact(this.defaultConnectionTimeout.millis()));
        }
        if (request.readTimeout() != null) {
            config.setSocketTimeout(Math.toIntExact(request.readTimeout.millis()));
            config.setConnectionRequestTimeout(Math.toIntExact(request.readTimeout.millis()));
        } else {
            config.setSocketTimeout(Math.toIntExact(this.defaultReadTimeout.millis()));
            config.setConnectionRequestTimeout(Math.toIntExact(this.defaultReadTimeout.millis()));
        }
        internalRequest.setConfig(config.build());
        try (CloseableHttpResponse closeableHttpResponse = (CloseableHttpResponse)SocketAccess.doPrivileged(() -> this.lambda$execute$0((HttpRequestBase)internalRequest, localContext));){
            byte[] body;
            Header[] headers = closeableHttpResponse.getAllHeaders();
            HashMap<String, String[]> responseHeaders = new HashMap<String, String[]>(headers.length);
            for (Header header : headers) {
                if (responseHeaders.containsKey(header.getName())) {
                    String[] old = (String[])responseHeaders.get(header.getName());
                    String[] values = new String[old.length + 1];
                    System.arraycopy(old, 0, values, 0, old.length);
                    values[values.length - 1] = header.getValue();
                    responseHeaders.put(header.getName(), values);
                    continue;
                }
                responseHeaders.put(header.getName(), new String[]{header.getValue()});
            }
            if (closeableHttpResponse.getEntity() == null) {
                body = new byte[]{};
            } else {
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    try (SizeLimitInputStream is = new SizeLimitInputStream(this.maxResponseSize, closeableHttpResponse.getEntity().getContent());){
                        Streams.copy((InputStream)is, (OutputStream)outputStream);
                    }
                    body = outputStream.toByteArray();
                }
            }
            HttpResponse httpResponse = new HttpResponse(closeableHttpResponse.getStatusLine().getStatusCode(), body, responseHeaders);
            return httpResponse;
        }
    }

    private URI createURI(HttpRequest request) {
        try {
            ArrayList qparams = new ArrayList(request.params.size());
            request.params.forEach((k, v) -> qparams.add(new BasicNameValuePair(k, v)));
            URI uri = URIUtils.createURI((String)request.scheme.scheme(), (String)request.host, (int)request.port, (String)request.path, (String)URLEncodedUtils.format(qparams, (String)"UTF-8"), null);
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private /* synthetic */ CloseableHttpResponse lambda$execute$0(HttpRequestBase internalRequest, HttpClientContext localContext) throws IOException {
        return this.client.execute((HttpUriRequest)internalRequest, (HttpContext)localContext);
    }

    final class HttpMethodWithEntity
    extends HttpEntityEnclosingRequestBase {
        private final String methodName;

        HttpMethodWithEntity(URI uri, String methodName) {
            this.methodName = methodName;
            this.setURI(uri);
        }

        public String getMethod() {
            return this.methodName;
        }
    }
}

