/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.GetTrialStatusResponse;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.XPackClient;
import org.elasticsearch.xpack.rest.XPackRestHandler;

public class RestGetTrialStatus
extends XPackRestHandler {
    RestGetTrialStatus(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, URI_BASE + "/license/trial_status", (RestHandler)this);
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, XPackClient client) throws IOException {
        return channel -> client.licensing().prepareGetUpgradeToTrial().execute((ActionListener)new RestBuilderListener<GetTrialStatusResponse>(channel){

            public RestResponse buildResponse(GetTrialStatusResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                builder.field("eligible_to_start_trial", response.isEligibleToStartTrial());
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    public String getName() {
        return "xpack_trial_status_action";
    }
}

