/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RawCollationKey;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.IndexableBinaryStringTools;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;

public class ICUCollationKeywordFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "icu_collation_keyword";
    private final String rules;
    private final String language;
    private final String country;
    private final String variant;
    private final String strength;
    private final String decomposition;
    private final String alternate;
    private final boolean caseLevel;
    private final String caseFirst;
    private final boolean numeric;
    private final String variableTop;
    private final boolean hiraganaQuaternaryMode;
    private int ignoreAbove;
    private final Collator collator;
    private final String nullValue;

    protected ICUCollationKeywordFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, String rules, String language, String country, String variant, String strength, String decomposition, String alternate, boolean caseLevel, String caseFirst, boolean numeric, String variableTop, boolean hiraganaQuaternaryMode, int ignoreAbove, Collator collator, String nullValue) {
        super(simpleName, fieldType, mappedFieldType, multiFields, copyTo);
        assert (collator.isFrozen());
        this.rules = rules;
        this.language = language;
        this.country = country;
        this.variant = variant;
        this.strength = strength;
        this.decomposition = decomposition;
        this.alternate = alternate;
        this.caseLevel = caseLevel;
        this.caseFirst = caseFirst;
        this.numeric = numeric;
        this.variableTop = variableTop;
        this.hiraganaQuaternaryMode = hiraganaQuaternaryMode;
        this.ignoreAbove = ignoreAbove;
        this.collator = collator;
        this.nullValue = nullValue;
    }

    public CollationFieldType fieldType() {
        return (CollationFieldType)super.fieldType();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        ICUCollationKeywordFieldMapper icuMergeWith = (ICUCollationKeywordFieldMapper)other;
        if (!Objects.equals(this.collator, icuMergeWith.collator)) {
            conflicts.add("mapper [" + this.name() + "] has different [collator]");
        }
        if (!Objects.equals(this.rules, icuMergeWith.rules)) {
            conflicts.add("Cannot update parameter [rules] for [icu_collation_keyword]");
        }
        if (!Objects.equals(this.language, icuMergeWith.language)) {
            conflicts.add("Cannot update parameter [language] for [icu_collation_keyword]");
        }
        if (!Objects.equals(this.country, icuMergeWith.country)) {
            conflicts.add("Cannot update parameter [country] for [icu_collation_keyword]");
        }
        if (!Objects.equals(this.variant, icuMergeWith.variant)) {
            conflicts.add("Cannot update parameter [variant] for [icu_collation_keyword]");
        }
        if (!Objects.equals(this.strength, icuMergeWith.strength)) {
            conflicts.add("Cannot update parameter [strength] for [icu_collation_keyword]");
        }
        if (!Objects.equals(this.decomposition, icuMergeWith.decomposition)) {
            conflicts.add("Cannot update parameter [decomposition] for [icu_collation_keyword]");
        }
        if (!Objects.equals(this.alternate, icuMergeWith.alternate)) {
            conflicts.add("Cannot update parameter [alternate] for [icu_collation_keyword]");
        }
        if (this.caseLevel != icuMergeWith.caseLevel) {
            conflicts.add("Cannot update parameter [case_level] for [icu_collation_keyword]");
        }
        if (!Objects.equals(this.caseFirst, icuMergeWith.caseFirst)) {
            conflicts.add("Cannot update parameter [case_first] for [icu_collation_keyword]");
        }
        if (this.numeric != icuMergeWith.numeric) {
            conflicts.add("Cannot update parameter [numeric] for [icu_collation_keyword]");
        }
        if (!Objects.equals(this.variableTop, icuMergeWith.variableTop)) {
            conflicts.add("Cannot update parameter [variable_top] for [icu_collation_keyword]");
        }
        if (this.hiraganaQuaternaryMode != icuMergeWith.hiraganaQuaternaryMode) {
            conflicts.add("Cannot update parameter [hiragana_quaternary_mode] for [icu_collation_keyword]");
        }
        this.ignoreAbove = icuMergeWith.ignoreAbove;
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (this.fieldType.indexOptions() != IndexOptions.NONE && (includeDefaults || this.fieldType.indexOptions() != IndexOptions.DOCS)) {
            builder.field("index_options", ICUCollationKeywordFieldMapper.indexOptionToString((IndexOptions)this.fieldType.indexOptions()));
        }
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (includeDefaults || this.fieldType.omitNorms() != KeywordFieldMapper.Defaults.FIELD_TYPE.omitNorms()) {
            builder.field("norms", !this.fieldType.omitNorms());
        }
        if (includeDefaults || this.rules != null) {
            builder.field("rules", this.rules);
        }
        if (includeDefaults || this.language != null) {
            builder.field("language", this.language);
        }
        if (includeDefaults || this.country != null) {
            builder.field("country", this.country);
        }
        if (includeDefaults || this.variant != null) {
            builder.field("variant", this.variant);
        }
        if (includeDefaults || this.strength != null) {
            builder.field("strength", this.strength);
        }
        if (includeDefaults || this.decomposition != null) {
            builder.field("decomposition", this.decomposition);
        }
        if (includeDefaults || this.alternate != null) {
            builder.field("alternate", this.alternate);
        }
        if (includeDefaults || this.caseLevel) {
            builder.field("case_level", this.caseLevel);
        }
        if (includeDefaults || this.caseFirst != null) {
            builder.field("case_first", this.caseFirst);
        }
        if (includeDefaults || this.numeric) {
            builder.field("numeric", this.numeric);
        }
        if (includeDefaults || this.variableTop != null) {
            builder.field("variable_top", this.variableTop);
        }
        if (includeDefaults || this.hiraganaQuaternaryMode) {
            builder.field("hiragana_quaternary_mode", this.hiraganaQuaternaryMode);
        }
        if (includeDefaults || this.ignoreAbove != Integer.MAX_VALUE) {
            builder.field("ignore_above", this.ignoreAbove);
        }
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        XContentParser parser;
        String value = context.externalValueSet() ? context.externalValue().toString() : ((parser = context.parser()).currentToken() == XContentParser.Token.VALUE_NULL ? this.nullValue : parser.textOrNull());
        if (value == null || value.length() > this.ignoreAbove) {
            return;
        }
        RawCollationKey key = this.collator.getRawCollationKey(value, null);
        BytesRef binaryValue = new BytesRef(key.bytes, 0, key.size);
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            Field field = new Field(this.mappedFieldType.name(), binaryValue, (IndexableFieldType)this.fieldType);
            context.doc().add((IndexableField)field);
        }
        if (this.fieldType().hasDocValues()) {
            context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), binaryValue));
        } else if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            this.createFieldNamesField(context);
        }
    }

    public static final class CollationFieldType
    extends StringFieldType {
        private final Collator collator;
        private final String nullValue;
        private final int ignoreAbove;
        public static DocValueFormat COLLATE_FORMAT = new DocValueFormat(){

            public String getWriteableName() {
                return "collate";
            }

            public void writeTo(StreamOutput out) {
            }

            public String format(BytesRef value) {
                int encodedLength = IndexableBinaryStringTools.getEncodedLength(value.bytes, value.offset, value.length);
                char[] encoded = new char[encodedLength];
                IndexableBinaryStringTools.encode(value.bytes, value.offset, value.length, encoded, 0, encodedLength);
                return new String(encoded, 0, encodedLength);
            }

            public BytesRef parseBytesRef(String value) {
                char[] encoded = value.toCharArray();
                int decodedLength = IndexableBinaryStringTools.getDecodedLength(encoded, 0, encoded.length);
                byte[] decoded = new byte[decodedLength];
                IndexableBinaryStringTools.decode(encoded, 0, encoded.length, decoded, 0, decodedLength);
                return new BytesRef(decoded);
            }
        };

        public CollationFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, Collator collator, String nullValue, int ignoreAbove, Map<String, String> meta) {
            super(name, isSearchable, isStored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.collator = collator;
            this.nullValue = nullValue;
            this.ignoreAbove = ignoreAbove;
        }

        public CollationFieldType(String name, boolean searchable, Collator collator) {
            this(name, searchable, false, true, collator, null, Integer.MAX_VALUE, Collections.emptyMap());
        }

        public CollationFieldType(String name, Collator collator) {
            this(name, true, false, true, collator, null, Integer.MAX_VALUE, Collections.emptyMap());
        }

        public String typeName() {
            return ICUCollationKeywordFieldMapper.CONTENT_TYPE;
        }

        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), mapperService, this.nullValue){

                protected String parseSourceValue(Object value) {
                    String keywordValue = value.toString();
                    if (keywordValue.length() > ignoreAbove) {
                        return null;
                    }
                    return keywordValue;
                }
            };
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.BYTES);
        }

        protected BytesRef indexedValueForSearch(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            if (this.collator != null) {
                RawCollationKey key = this.collator.getRawCollationKey(value.toString(), null);
                return new BytesRef(key.bytes, 0, key.size);
            }
            throw new IllegalStateException("collator is null");
        }

        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, QueryShardContext context) {
            throw new UnsupportedOperationException("[fuzzy] queries are not supported on [icu_collation_keyword] fields.");
        }

        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            throw new UnsupportedOperationException("[prefix] queries are not supported on [icu_collation_keyword] fields.");
        }

        public Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            throw new UnsupportedOperationException("[wildcard] queries are not supported on [icu_collation_keyword] fields.");
        }

        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            throw new UnsupportedOperationException("[regexp] queries are not supported on [icu_collation_keyword] fields.");
        }

        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            return COLLATE_FORMAT;
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final int IGNORE_ABOVE = Integer.MAX_VALUE;

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParsers.parseField((FieldMapper.Builder)builder, (String)name, node, (Mapper.TypeParser.ParserContext)parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                switch (fieldName) {
                    case "null_value": {
                        if (fieldNode == null) {
                            throw new MapperParsingException("Property [null_value] cannot be null.");
                        }
                        builder.nullValue(fieldNode.toString());
                        iterator.remove();
                        break;
                    }
                    case "ignore_above": {
                        builder.ignoreAbove(XContentMapValues.nodeIntegerValue((Object)fieldNode, (int)-1));
                        iterator.remove();
                        break;
                    }
                    case "norms": {
                        builder.omitNorms(!XContentMapValues.nodeBooleanValue((Object)fieldNode, (String)"norms"));
                        iterator.remove();
                        break;
                    }
                    case "rules": {
                        builder.rules(XContentMapValues.nodeStringValue((Object)fieldNode, null));
                        iterator.remove();
                        break;
                    }
                    case "language": {
                        builder.language(XContentMapValues.nodeStringValue((Object)fieldNode, null));
                        iterator.remove();
                        break;
                    }
                    case "country": {
                        builder.country(XContentMapValues.nodeStringValue((Object)fieldNode, null));
                        iterator.remove();
                        break;
                    }
                    case "variant": {
                        builder.variant(XContentMapValues.nodeStringValue((Object)fieldNode, null));
                        iterator.remove();
                        break;
                    }
                    case "strength": {
                        builder.strength(XContentMapValues.nodeStringValue((Object)fieldNode, null));
                        iterator.remove();
                        break;
                    }
                    case "decomposition": {
                        builder.decomposition(XContentMapValues.nodeStringValue((Object)fieldNode, null));
                        iterator.remove();
                        break;
                    }
                    case "alternate": {
                        builder.alternate(XContentMapValues.nodeStringValue((Object)fieldNode, null));
                        iterator.remove();
                        break;
                    }
                    case "case_level": {
                        builder.caseLevel(XContentMapValues.nodeBooleanValue((Object)fieldNode, (boolean)false));
                        iterator.remove();
                        break;
                    }
                    case "case_first": {
                        builder.caseFirst(XContentMapValues.nodeStringValue((Object)fieldNode, null));
                        iterator.remove();
                        break;
                    }
                    case "numeric": {
                        builder.numeric(XContentMapValues.nodeBooleanValue((Object)fieldNode, (boolean)false));
                        iterator.remove();
                        break;
                    }
                    case "variable_top": {
                        builder.variableTop(XContentMapValues.nodeStringValue((Object)fieldNode, null));
                        iterator.remove();
                        break;
                    }
                    case "hiragana_quaternary_mode": {
                        builder.hiraganaQuaternaryMode(XContentMapValues.nodeBooleanValue((Object)fieldNode, (boolean)false));
                        iterator.remove();
                        break;
                    }
                }
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        private String rules = null;
        private String language = null;
        private String country = null;
        private String variant = null;
        private String strength = null;
        private String decomposition = null;
        private String alternate = null;
        private boolean caseLevel = false;
        private String caseFirst = null;
        private boolean numeric = false;
        private String variableTop = null;
        private boolean hiraganaQuaternaryMode = false;
        protected int ignoreAbove = Integer.MAX_VALUE;
        protected String nullValue;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder indexOptions(IndexOptions indexOptions) {
            if (indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS) > 0) {
                throw new IllegalArgumentException("The [icu_collation_keyword] field does not support positions, got [index_options]=" + FieldMapper.indexOptionToString((IndexOptions)indexOptions));
            }
            return (Builder)super.indexOptions(indexOptions);
        }

        public Builder ignoreAbove(int ignoreAbove) {
            if (ignoreAbove < 0) {
                throw new IllegalArgumentException("[ignore_above] must be positive, got " + ignoreAbove);
            }
            this.ignoreAbove = ignoreAbove;
            return this;
        }

        public String rules() {
            return this.rules;
        }

        public Builder rules(String rules) {
            this.rules = rules;
            return this;
        }

        public String language() {
            return this.language;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public String country() {
            return this.country;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public String variant() {
            return this.variant;
        }

        public Builder variant(String variant) {
            this.variant = variant;
            return this;
        }

        public String strength() {
            return this.strength;
        }

        public Builder strength(String strength) {
            this.strength = strength;
            return this;
        }

        public String decomposition() {
            return this.decomposition;
        }

        public Builder decomposition(String decomposition) {
            this.decomposition = decomposition;
            return this;
        }

        public String alternate() {
            return this.alternate;
        }

        public Builder alternate(String alternate) {
            this.alternate = alternate;
            return this;
        }

        public boolean caseLevel() {
            return this.caseLevel;
        }

        public Builder caseLevel(boolean caseLevel) {
            this.caseLevel = caseLevel;
            return this;
        }

        public String caseFirst() {
            return this.caseFirst;
        }

        public Builder caseFirst(String caseFirst) {
            this.caseFirst = caseFirst;
            return this;
        }

        public boolean numeric() {
            return this.numeric;
        }

        public Builder numeric(boolean numeric) {
            this.numeric = numeric;
            return this;
        }

        public String variableTop() {
            return this.variableTop;
        }

        public Builder variableTop(String variableTop) {
            this.variableTop = variableTop;
            return this;
        }

        public boolean hiraganaQuaternaryMode() {
            return this.hiraganaQuaternaryMode;
        }

        public Builder hiraganaQuaternaryMode(boolean hiraganaQuaternaryMode) {
            this.hiraganaQuaternaryMode = hiraganaQuaternaryMode;
            return this;
        }

        public Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public Collator buildCollator() {
            Collator collator;
            if (this.rules != null) {
                try {
                    collator = new RuleBasedCollator(this.rules);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to parse collation rules", e);
                }
            } else if (this.language != null) {
                ULocale locale = this.country != null ? (this.variant != null ? new ULocale(this.language, this.country, this.variant) : new ULocale(this.language, this.country)) : new ULocale(this.language);
                collator = Collator.getInstance((ULocale)locale);
            } else {
                collator = Collator.getInstance((ULocale)ULocale.ROOT);
            }
            if (this.strength != null) {
                if (this.strength.equalsIgnoreCase("primary")) {
                    collator.setStrength(0);
                } else if (this.strength.equalsIgnoreCase("secondary")) {
                    collator.setStrength(1);
                } else if (this.strength.equalsIgnoreCase("tertiary")) {
                    collator.setStrength(2);
                } else if (this.strength.equalsIgnoreCase("quaternary")) {
                    collator.setStrength(3);
                } else if (this.strength.equalsIgnoreCase("identical")) {
                    collator.setStrength(15);
                } else {
                    throw new IllegalArgumentException("Invalid strength: " + this.strength);
                }
            }
            if (this.decomposition != null) {
                if (this.decomposition.equalsIgnoreCase("no")) {
                    collator.setDecomposition(16);
                } else if (this.decomposition.equalsIgnoreCase("canonical")) {
                    collator.setDecomposition(17);
                } else {
                    throw new IllegalArgumentException("Invalid decomposition: " + this.decomposition);
                }
            }
            RuleBasedCollator rbc = (RuleBasedCollator)collator;
            if (this.alternate != null) {
                if (this.alternate.equalsIgnoreCase("shifted")) {
                    rbc.setAlternateHandlingShifted(true);
                } else if (this.alternate.equalsIgnoreCase("non-ignorable")) {
                    rbc.setAlternateHandlingShifted(false);
                } else {
                    throw new IllegalArgumentException("Invalid alternate: " + this.alternate);
                }
            }
            if (this.caseLevel) {
                rbc.setCaseLevel(true);
            }
            if (this.caseFirst != null) {
                if (this.caseFirst.equalsIgnoreCase("lower")) {
                    rbc.setLowerCaseFirst(true);
                } else if (this.caseFirst.equalsIgnoreCase("upper")) {
                    rbc.setUpperCaseFirst(true);
                } else {
                    throw new IllegalArgumentException("Invalid caseFirst: " + this.caseFirst);
                }
            }
            if (this.numeric) {
                rbc.setNumericCollation(true);
            }
            if (this.variableTop != null) {
                rbc.setVariableTop(this.variableTop);
            }
            if (this.hiraganaQuaternaryMode) {
                rbc.setHiraganaQuaternary(true);
            }
            return collator.freeze();
        }

        public ICUCollationKeywordFieldMapper build(Mapper.BuilderContext context) {
            Collator collator = this.buildCollator();
            CollationFieldType ft = new CollationFieldType(this.buildFullName(context), this.indexed, this.fieldType.stored(), this.hasDocValues, collator, this.nullValue, this.ignoreAbove, this.meta);
            return new ICUCollationKeywordFieldMapper(this.name, this.fieldType, (MappedFieldType)ft, this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo, this.rules, this.language, this.country, this.variant, this.strength, this.decomposition, this.alternate, this.caseLevel, this.caseFirst, this.numeric, this.variableTop, this.hiraganaQuaternaryMode, this.ignoreAbove, collator, this.nullValue);
        }
    }
}

