/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.framework.internal;

import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularDataSupport;
import org.eclipse.gemini.management.internal.OSGiProperties;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.jmx.framework.wiring.BundleWiringStateMBean;

public class OSGiBundleRequirement {
    private final BundleRequirement bundleRequirement;

    public OSGiBundleRequirement(BundleRequirement bundleRequirement) {
        this.bundleRequirement = bundleRequirement;
    }

    public CompositeData asCompositeData() {
        try {
            TabularDataSupport tabularAttributes = new TabularDataSupport(BundleWiringStateMBean.ATTRIBUTES_TYPE);
            Map attributes = this.bundleRequirement.getAttributes();
            for (Map.Entry attribute : attributes.entrySet()) {
                tabularAttributes.put(OSGiProperties.encode((String)attribute.getKey(), attribute.getValue()));
            }
            TabularDataSupport tabularDirectives = new TabularDataSupport(BundleWiringStateMBean.DIRECTIVES_TYPE);
            Map directives = this.bundleRequirement.getDirectives();
            for (Map.Entry directive : directives.entrySet()) {
                tabularDirectives.put(new CompositeDataSupport(BundleWiringStateMBean.DIRECTIVE_TYPE, OSGiProperties.getDirectiveKeyValueItem((String)directive.getKey(), directive.getValue())));
            }
            HashMap<String, Object> items = new HashMap<String, Object>();
            items.put("Attributes", tabularAttributes);
            items.put("Directives", tabularDirectives);
            items.put("Namespace", this.bundleRequirement.getNamespace());
            return new CompositeDataSupport(BundleWiringStateMBean.BUNDLE_REQUIREMENT_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle requirment open data", e);
        }
    }
}

