/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.framework;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.eclipse.gemini.management.framework.internal.OSGiBundleRevision;
import org.eclipse.gemini.management.framework.internal.OSGiBundleRevisionIdTracker;
import org.eclipse.gemini.management.framework.internal.OSGiBundleWiring;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.jmx.framework.wiring.BundleWiringStateMBean;

public final class BundleWiringState
implements BundleWiringStateMBean {
    private final String ALL_NAMESPACE = "osgi.wiring.all";
    private final BundleContext bundleContext;

    public BundleWiringState(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public CompositeData[] getCurrentRevisionDeclaredRequirements(long bundleId, String namespace) throws IOException {
        namespace = this.processNamespace(namespace);
        BundleRevision bundleRevision = (BundleRevision)this.getBundle(bundleId).adapt(BundleRevision.class);
        return new OSGiBundleRevision(bundleRevision).requirementsAsCompositeDataArray(namespace);
    }

    @Override
    public CompositeData[] getCurrentRevisionDeclaredCapabilities(long bundleId, String namespace) throws IOException {
        namespace = this.processNamespace(namespace);
        BundleRevision bundleRevision = (BundleRevision)this.getBundle(bundleId).adapt(BundleRevision.class);
        return new OSGiBundleRevision(bundleRevision).capabilitiesAsCompositeDataArray(namespace);
    }

    @Override
    public CompositeData getCurrentWiring(long bundleId, String namespace) throws IOException {
        namespace = this.processNamespace(namespace);
        BundleWiring wiring = (BundleWiring)this.getBundle(bundleId).adapt(BundleWiring.class);
        OSGiBundleRevisionIdTracker revisionTracker = new OSGiBundleRevisionIdTracker();
        if (wiring != null) {
            return new OSGiBundleWiring(wiring).asCompositeData(namespace, bundleId, revisionTracker);
        }
        return null;
    }

    @Override
    public TabularData getCurrentWiringClosure(long rootBundleId, String namespace) throws IOException {
        namespace = this.processNamespace(namespace);
        BundleWiring wiring = (BundleWiring)this.getBundle(rootBundleId).adapt(BundleWiring.class);
        HashMap<BundleRevision, OSGiBundleWiring> mappings = new HashMap<BundleRevision, OSGiBundleWiring>();
        this.processWiring(mappings, wiring, namespace);
        TabularDataSupport table = new TabularDataSupport(BundleWiringStateMBean.BUNDLES_WIRING_TYPE);
        OSGiBundleRevisionIdTracker revisionTracker = new OSGiBundleRevisionIdTracker();
        for (Map.Entry osgiBundleWiring : mappings.entrySet()) {
            table.put(((OSGiBundleWiring)osgiBundleWiring.getValue()).asCompositeData(namespace, ((BundleRevision)osgiBundleWiring.getKey()).getBundle().getBundleId(), revisionTracker));
        }
        return table;
    }

    @Override
    public TabularData getRevisionsDeclaredRequirements(long bundleId, String namespace) throws IOException {
        namespace = this.processNamespace(namespace);
        List bundleRevisions = ((BundleRevisions)this.getBundle(bundleId).adapt(BundleRevisions.class)).getRevisions();
        TabularDataSupport table = new TabularDataSupport(BundleWiringStateMBean.REVISIONS_REQUIREMENTS_TYPE);
        int revisionCounter = 0;
        for (BundleRevision bundleRevision : bundleRevisions) {
            table.put(new OSGiBundleRevision(bundleRevision).requirementsAsCompositeData(namespace, revisionCounter));
            ++revisionCounter;
        }
        return table;
    }

    @Override
    public TabularData getRevisionsDeclaredCapabilities(long bundleId, String namespace) throws IOException {
        namespace = this.processNamespace(namespace);
        List bundleRevisions = ((BundleRevisions)this.getBundle(bundleId).adapt(BundleRevisions.class)).getRevisions();
        TabularDataSupport table = new TabularDataSupport(BundleWiringStateMBean.REVISIONS_CAPABILITIES_TYPE);
        int revisionCounter = 0;
        for (BundleRevision bundleRevision : bundleRevisions) {
            table.put(new OSGiBundleRevision(bundleRevision).capabilitiesAsCompositeData(namespace, revisionCounter));
            ++revisionCounter;
        }
        return table;
    }

    @Override
    public TabularData getRevisionsWiring(long bundleId, String namespace) throws IOException {
        namespace = this.processNamespace(namespace);
        List bundleRevisions = ((BundleRevisions)this.getBundle(bundleId).adapt(BundleRevisions.class)).getRevisions();
        TabularDataSupport table = new TabularDataSupport(BundleWiringStateMBean.BUNDLES_WIRING_TYPE);
        OSGiBundleRevisionIdTracker revisionTracker = new OSGiBundleRevisionIdTracker();
        for (BundleRevision bundleRevision : bundleRevisions) {
            BundleWiring wiring = bundleRevision.getWiring();
            if (wiring == null) continue;
            table.put(new OSGiBundleWiring(wiring).asCompositeData(namespace, bundleId, revisionTracker));
        }
        return table;
    }

    @Override
    public TabularData getRevisionsWiringClosure(long rootBundleId, String namespace) throws IOException {
        namespace = this.processNamespace(namespace);
        List bundleRevisions = ((BundleRevisions)this.getBundle(rootBundleId).adapt(BundleRevisions.class)).getRevisions();
        HashMap<BundleRevision, OSGiBundleWiring> mappings = new HashMap<BundleRevision, OSGiBundleWiring>();
        for (BundleRevision bundleRevision : bundleRevisions) {
            this.processWiring(mappings, bundleRevision.getWiring(), namespace);
        }
        TabularDataSupport table = new TabularDataSupport(BundleWiringStateMBean.BUNDLES_WIRING_TYPE);
        OSGiBundleRevisionIdTracker revisionTracker = new OSGiBundleRevisionIdTracker();
        for (Map.Entry osgiBundleWiring : mappings.entrySet()) {
            table.put(((OSGiBundleWiring)osgiBundleWiring.getValue()).asCompositeData(namespace, ((BundleRevision)osgiBundleWiring.getKey()).getBundle().getBundleId(), revisionTracker));
        }
        return table;
    }

    private Bundle getBundle(long bundleId) throws IOException {
        Bundle b = this.bundleContext.getBundle(bundleId);
        if (b == null) {
            throw new IOException("Bundle with id: " + bundleId + " does not exist");
        }
        return b;
    }

    private String processNamespace(String namespace) {
        if ("osgi.wiring.all".equals(namespace)) {
            return null;
        }
        return namespace;
    }

    private void processWiring(Map<BundleRevision, OSGiBundleWiring> mappings, BundleWiring wiring, String namespace) {
        BundleRevision bundleRevision;
        if (wiring != null && !mappings.containsKey(bundleRevision = wiring.getRevision())) {
            mappings.put(bundleRevision, new OSGiBundleWiring(wiring));
            this.processRequiredWirings(mappings, wiring, namespace);
            this.processProvidedWirings(mappings, wiring, namespace);
        }
    }

    private void processRequiredWirings(Map<BundleRevision, OSGiBundleWiring> mappings, BundleWiring wiring, String namespace) {
        List requiredWires = wiring.getRequiredWires(namespace);
        if (requiredWires != null) {
            for (BundleWire bundleWire : requiredWires) {
                this.processWiring(mappings, bundleWire.getProviderWiring(), namespace);
            }
        }
    }

    private void processProvidedWirings(Map<BundleRevision, OSGiBundleWiring> mappings, BundleWiring wiring, String namespace) {
        List providedWires = wiring.getProvidedWires(namespace);
        if (providedWires != null) {
            for (BundleWire bundleWire : providedWires) {
                this.processWiring(mappings, bundleWire.getRequirerWiring(), namespace);
            }
        }
    }
}

