/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.workflow;

import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiSession;
import com.ecyrd.jspwiki.workflow.Decision;
import com.ecyrd.jspwiki.workflow.Outcome;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class DecisionQueue
implements Serializable {
    private static final long serialVersionUID = -7172912793410302533L;
    private LinkedList<Decision> m_queue = new LinkedList();
    private volatile int m_next = 1000;

    protected synchronized void add(Decision decision) {
        this.m_queue.addLast(decision);
        decision.setId(this.nextId());
    }

    protected Decision[] decisions() {
        return this.m_queue.toArray(new Decision[this.m_queue.size()]);
    }

    protected synchronized void remove(Decision decision) {
        this.m_queue.remove(decision);
    }

    public Collection getActorDecisions(WikiSession session) {
        ArrayList<Decision> decisions = new ArrayList<Decision>();
        if (session.isAuthenticated()) {
            Principal[] principals = session.getPrincipals();
            Principal[] rolePrincipals = session.getRoles();
            for (Decision decision : this.m_queue) {
                for (Principal principal : principals) {
                    if (!((Object)principal).equals(decision.getActor())) continue;
                    decisions.add(decision);
                }
                for (Principal principal : rolePrincipals) {
                    if (!((Object)principal).equals(decision.getActor())) continue;
                    decisions.add(decision);
                }
            }
        }
        return decisions;
    }

    public void decide(Decision decision, Outcome outcome) throws WikiException {
        decision.decide(outcome);
        if (decision.isCompleted()) {
            this.remove(decision);
        }
    }

    public synchronized void reassign(Decision decision, Principal owner) throws WikiException {
        if (decision.isReassignable()) {
            decision.reassign(owner);
            return;
        }
        throw new IllegalStateException("Reassignments not allowed for this decision.");
    }

    private synchronized int nextId() {
        int current = this.m_next++;
        return current;
    }
}

