/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.ui;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.event.WikiEventManager;
import com.ecyrd.jspwiki.event.WikiPageEvent;
import com.ecyrd.jspwiki.ui.TemplateManager;
import com.ecyrd.jspwiki.ui.WikiServletFilter;
import com.ecyrd.jspwiki.url.DefaultURLConstructor;
import com.ecyrd.jspwiki.util.UtilJ2eeCompat;
import com.ecyrd.jspwiki.util.WatchDog;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.log4j.NDC;

public class WikiJSPFilter
extends WikiServletFilter {
    private Boolean m_useOutputStream;

    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        ServletContext context = config.getServletContext();
        this.m_useOutputStream = UtilJ2eeCompat.useOutputStream(context.getServerInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        WatchDog w = this.m_engine.getCurrentWatchDog();
        try {
            HttpServletResponseWrapper responseWrapper;
            NDC.push((String)(this.m_engine.getApplicationName() + ":" + ((HttpServletRequest)request).getRequestURI()));
            w.enterState("Filtering for URL " + ((HttpServletRequest)request).getRequestURI(), 90);
            if (this.m_useOutputStream.booleanValue()) {
                log.debug((Object)"Using ByteArrayResponseWrapper");
                responseWrapper = new ByteArrayResponseWrapper((HttpServletResponse)response);
            } else {
                log.debug((Object)"Using MyServletResponseWrapper");
                responseWrapper = new MyServletResponseWrapper((HttpServletResponse)response);
            }
            String pagename = DefaultURLConstructor.parsePageFromURL((HttpServletRequest)request, response.getCharacterEncoding());
            this.fireEvent(24, pagename);
            super.doFilter(request, (ServletResponse)responseWrapper, chain);
            try {
                w.enterState("Delivering response", 30);
                WikiContext wikiContext = this.getWikiContext(request);
                String r = this.filter(wikiContext, (HttpServletResponse)responseWrapper);
                response.getWriter().write(r);
                if (wikiContext != null) {
                    wikiContext.getWikiSession().clearMessages();
                }
                this.fireEvent(25, pagename);
                Object var10_9 = null;
                w.exitState();
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                w.exitState();
                throw throwable;
            }
            Object var12_12 = null;
            w.exitState();
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            w.exitState();
            NDC.pop();
            NDC.remove();
            throw throwable;
        }
        NDC.pop();
        NDC.remove();
    }

    private String filter(WikiContext wikiContext, HttpServletResponse response) {
        String string = response.toString();
        if (wikiContext != null) {
            String[] resourceTypes = TemplateManager.getResourceTypes(wikiContext);
            for (int i = 0; i < resourceTypes.length; ++i) {
                string = this.insertResources(wikiContext, string, resourceTypes[i]);
            }
            String[] headers = TemplateManager.getResourceRequests(wikiContext, "httpheader");
            for (int i = 0; i < headers.length; ++i) {
                String key = headers[i];
                String value = "";
                int split = headers[i].indexOf(58);
                if (split > 0 && split < headers[i].length() - 1) {
                    key = headers[i].substring(0, split);
                    value = headers[i].substring(split + 1);
                }
                response.addHeader(key.trim(), value.trim());
            }
        }
        return string;
    }

    private String insertResources(WikiContext wikiContext, String string, String type) {
        if (wikiContext == null) {
            return string;
        }
        String marker = TemplateManager.getMarker(wikiContext, type);
        int idx = string.indexOf(marker);
        if (idx == -1) {
            return string;
        }
        log.debug((Object)"...Inserting...");
        String[] resources = TemplateManager.getResourceRequests(wikiContext, type);
        StringBuffer concat = new StringBuffer(resources.length * 40);
        for (int i = 0; i < resources.length; ++i) {
            log.debug((Object)("...:::" + resources[i]));
            concat.append(resources[i]);
        }
        string = TextUtil.replaceString(string, idx, idx + marker.length(), concat.toString());
        return string;
    }

    protected final void fireEvent(int type, String pagename) {
        if (WikiEventManager.isListening(this.m_engine)) {
            WikiEventManager.fireEvent(this.m_engine, new WikiPageEvent(this.m_engine, type, pagename));
        }
    }

    private static class ByteArrayResponseWrapper
    extends HttpServletResponseWrapper {
        private ByteArrayOutputStream m_output = new ByteArrayOutputStream(4096);
        private HttpServletResponse m_response;
        private static final int INIT_BUFFER_SIZE = 4096;

        public ByteArrayResponseWrapper(HttpServletResponse r) {
            super(r);
            this.m_response = r;
        }

        public PrintWriter getWriter() {
            return new PrintWriter((OutputStream)this.getOutputStream(), true);
        }

        public ServletOutputStream getOutputStream() {
            return new MyServletOutputStream(this.m_output);
        }

        public String toString() {
            try {
                return this.m_output.toString(this.m_response.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                WikiServletFilter.log.error((Object)(ByteArrayResponseWrapper.class + " Unsupported Encoding"), (Throwable)e);
                return null;
            }
        }

        static class MyServletOutputStream
        extends ServletOutputStream {
            private DataOutputStream m_stream;

            public MyServletOutputStream(OutputStream aOutput) {
                this.m_stream = new DataOutputStream(aOutput);
            }

            public void write(int aInt) throws IOException {
                this.m_stream.write(aInt);
            }
        }
    }

    private static class MyServletResponseWrapper
    extends HttpServletResponseWrapper {
        private CharArrayWriter m_output = new CharArrayWriter(4096);
        private static final int INIT_BUFFER_SIZE = 4096;

        public MyServletResponseWrapper(HttpServletResponse r) {
            super(r);
        }

        public PrintWriter getWriter() {
            return new PrintWriter(this.m_output);
        }

        public ServletOutputStream getOutputStream() {
            return new MyServletOutputStream(this.m_output);
        }

        public String toString() {
            return this.m_output.toString();
        }

        static class MyServletOutputStream
        extends ServletOutputStream {
            CharArrayWriter m_buffer;

            public MyServletOutputStream(CharArrayWriter aCharArrayWriter) {
                this.m_buffer = aCharArrayWriter;
            }

            public void write(int aInt) {
                this.m_buffer.write(aInt);
            }
        }
    }
}

