/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.ui;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiSession;
import com.ecyrd.jspwiki.auth.NoSuchPrincipalException;
import com.ecyrd.jspwiki.auth.UserManager;
import com.ecyrd.jspwiki.auth.WikiPrincipal;
import com.ecyrd.jspwiki.auth.WikiSecurityException;
import com.ecyrd.jspwiki.auth.authorize.Group;
import com.ecyrd.jspwiki.auth.authorize.GroupManager;
import com.ecyrd.jspwiki.auth.user.UserDatabase;
import com.ecyrd.jspwiki.auth.user.UserProfile;
import com.ecyrd.jspwiki.util.CommentedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class Installer {
    public static final String ADMIN_ID = "admin";
    public static final String ADMIN_NAME = "Administrator";
    public static final String INSTALL_INFO = "Installer.Info";
    public static final String INSTALL_WARNING = "Installer.Warning";
    public static final String INSTALL_ERROR = "Installer.Error";
    public static final String APP_NAME = "jspwiki.applicationName";
    public static final String BASE_URL = "jspwiki.baseURL";
    public static final String STORAGE_DIR = "jspwiki.basicAttachmentProvider.storageDir";
    public static final String LOG_DIR = "log4j.appender.FileLog.File";
    public static final String PAGE_DIR = "jspwiki.fileSystemProvider.pageDir";
    public static final String WORK_DIR = "jspwiki.workDir";
    public static final String ADMIN_GROUP = "Admin";
    private final WikiSession m_session;
    private final File m_propertyFile;
    private final Properties m_props;
    private final WikiEngine m_engine;
    private HttpServletRequest m_request;
    private boolean m_validated;

    public Installer(HttpServletRequest request, ServletConfig config) {
        this.m_engine = WikiEngine.getInstance(config);
        this.m_session = WikiSession.getWikiSession(this.m_engine, request);
        ServletContext context = config.getServletContext();
        String path = context.getRealPath("/");
        this.m_propertyFile = new File(path, "/WEB-INF/jspwiki.properties");
        this.m_props = new CommentedProperties();
        this.m_request = request;
        this.m_validated = false;
    }

    public boolean adminExists() {
        UserManager userMgr = this.m_engine.getUserManager();
        UserDatabase userDb = userMgr.getUserDatabase();
        try {
            userDb.findByLoginName(ADMIN_ID);
            return true;
        }
        catch (NoSuchPrincipalException e) {
            return false;
        }
    }

    public String createAdministrator() throws WikiSecurityException {
        if (!this.m_validated) {
            throw new WikiSecurityException("Cannot create administrator because one or more of the installation settings are invalid.");
        }
        if (this.adminExists()) {
            return null;
        }
        UserManager userMgr = this.m_engine.getUserManager();
        UserDatabase userDb = userMgr.getUserDatabase();
        String password = null;
        try {
            userDb.findByLoginName(ADMIN_ID);
        }
        catch (NoSuchPrincipalException e) {
            password = TextUtil.generateRandomPassword();
            UserProfile profile = userDb.newProfile();
            profile.setLoginName(ADMIN_ID);
            profile.setFullname(ADMIN_NAME);
            profile.setPassword(password);
            userDb.save(profile);
        }
        GroupManager groupMgr = this.m_engine.getGroupManager();
        Group group = null;
        try {
            group = groupMgr.getGroup(ADMIN_GROUP);
            group.add(new WikiPrincipal(ADMIN_NAME));
        }
        catch (NoSuchPrincipalException e) {
            group = groupMgr.parseGroup(ADMIN_GROUP, ADMIN_NAME, true);
        }
        groupMgr.setGroup(this.m_session, group);
        return password;
    }

    public String getProperties() {
        return this.m_props.toString();
    }

    public String getPropertiesPath() {
        return this.m_propertyFile.getAbsolutePath();
    }

    public String getProperty(String key) {
        return this.m_props.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseProperties() throws Exception {
        ResourceBundle rb;
        block5: {
            rb = ResourceBundle.getBundle("CoreResources", this.m_session.getLocale());
            this.m_validated = false;
            try {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(this.m_propertyFile);
                    this.m_props.load(in);
                    Object var4_4 = null;
                    if (in == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    throw throwable;
                }
                ((InputStream)in).close();
            }
            catch (IOException e) {
                Object[] args = new Object[]{e.getMessage()};
                this.m_session.addMessage(INSTALL_ERROR, MessageFormat.format(rb.getString("install.installer.unable.read.props"), args));
            }
        }
        String nullValue = this.m_props.getProperty(APP_NAME, rb.getString("install.installer.default.appname"));
        this.parseProperty(APP_NAME, nullValue);
        nullValue = this.m_request.getRequestURL().toString();
        nullValue = nullValue.substring(0, nullValue.lastIndexOf(47)) + "/";
        this.parseProperty(BASE_URL, nullValue);
        this.sanitizeURL(BASE_URL);
        nullValue = this.m_props.getProperty(PAGE_DIR, rb.getString("install.installer.default.pagedir"));
        this.parseProperty(PAGE_DIR, nullValue);
        this.sanitizePath(PAGE_DIR);
        nullValue = this.m_props.getProperty(LOG_DIR, "/tmp/");
        this.parseProperty(LOG_DIR, nullValue);
        this.sanitizePath(LOG_DIR);
        nullValue = this.m_props.getProperty(WORK_DIR, "/tmp/");
        this.parseProperty(WORK_DIR, nullValue);
        this.sanitizePath(WORK_DIR);
        nullValue = this.m_props.getProperty("jspwiki.security", "jaas");
        this.parseProperty("jspwiki.security", nullValue);
        this.m_props.setProperty(STORAGE_DIR, this.m_props.getProperty(PAGE_DIR));
        this.m_props.setProperty("jspwiki.pageProvider", "VersioningFileProvider");
        this.m_props.setProperty("jspwiki.encoding", "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveProperties() {
        ResourceBundle rb = ResourceBundle.getBundle("CoreResources", this.m_session.getLocale());
        try {
            block4: {
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(this.m_propertyFile);
                    this.m_props.store(out, null);
                    Object var4_4 = null;
                    if (out == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    if (out == null) throw throwable;
                    ((OutputStream)out).close();
                    throw throwable;
                }
                ((OutputStream)out).close();
            }
            this.m_session.addMessage(INSTALL_INFO, rb.getString("install.installer.props.saved"));
            return;
        }
        catch (IOException e) {
            Object[] args = new Object[]{e.getMessage(), this.m_props.toString()};
            this.m_session.addMessage(INSTALL_ERROR, MessageFormat.format(rb.getString("install.installer.props.notsaved"), args));
        }
    }

    public boolean validateProperties() throws Exception {
        ResourceBundle rb = ResourceBundle.getBundle("CoreResources", this.m_session.getLocale());
        this.m_session.clearMessages(INSTALL_ERROR);
        this.parseProperties();
        this.validateNotNull(BASE_URL, rb.getString("install.installer.validate.baseurl"));
        this.validateNotNull(PAGE_DIR, rb.getString("install.installer.validate.pagedir"));
        this.validateNotNull(APP_NAME, rb.getString("install.installer.validate.appname"));
        this.validateNotNull(WORK_DIR, rb.getString("install.installer.validate.workdir"));
        this.validateNotNull(LOG_DIR, rb.getString("install.installer.validate.logdir"));
        if (this.m_session.getMessages(INSTALL_ERROR).length == 0) {
            this.m_validated = true;
        }
        return this.m_validated;
    }

    private void parseProperty(String param, String defaultValue) {
        String value = this.m_request.getParameter(param);
        if (value == null) {
            value = defaultValue;
        }
        this.m_props.put(param, value);
    }

    private void sanitizePath(String key) {
        String s = this.m_props.getProperty(key);
        s = TextUtil.replaceString(s, "\\", "\\\\");
        s = s.trim();
        this.m_props.put(key, s);
    }

    private void sanitizeURL(String key) {
        String s = this.m_props.getProperty(key);
        s = TextUtil.replaceString(s, "\\", "/");
        if (!(s = s.trim()).endsWith("/")) {
            s = s + "/";
        }
        this.m_props.put(key, s);
    }

    private void validateNotNull(String key, String message) {
        String value = this.m_props.getProperty(key);
        if (value == null || value.length() == 0) {
            this.m_session.addMessage(INSTALL_ERROR, message);
        }
    }
}

