/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.content;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.auth.acl.Acl;
import com.ecyrd.jspwiki.auth.acl.AclEntry;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.Permission;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.UUID;
import javax.activation.MimetypesFileTypeMap;
import net.sourceforge.stripes.util.Base64;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exporter {
    private PrintWriter m_out;
    private boolean m_verbose = false;
    private MimetypesFileTypeMap m_mimeTypes = new MimetypesFileTypeMap();
    private TreeSet<String> m_exportedPageTitles = new TreeSet();
    private static final String NS_JSPWIKI = "http://www.jspwiki.org/ns#";
    private static final String STRING = "String";
    private static final String JSPWIKI_CONTENT_TYPE = "text/x-wiki.jspwiki";
    private static final String NAME = "Name";
    private static final String BINARY = "Binary";
    private static final String DATE = "Date";
    private SimpleDateFormat m_isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public Exporter(OutputStream outStream, boolean verbose) throws UnsupportedEncodingException {
        this.m_out = new PrintWriter(new OutputStreamWriter(outStream, "UTF-8"));
        this.m_verbose = verbose;
    }

    public void export(WikiEngine engine) throws ProviderException, IOException {
        Collection allPages = engine.getPageManager().getAllPages();
        this.exportDocumentHeader();
        for (WikiPage p : allPages) {
            this.exportPage(engine, p);
        }
        this.exportDocumentFooter();
    }

    protected void export(String dir) throws IOException {
        System.out.println("Exporting a FileSystemProvider/RCSFileProvider/VersioningFileProvider compatible repository.");
        System.out.println("This version does not export attributes, ACLs or attachments. Please use --properties for that.");
        File df = new File(dir);
        File[] pages = df.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".txt");
            }
        });
        this.exportDocumentHeader();
        for (File f : pages) {
            String pageName = f.getName();
            pageName = pageName.replace(".txt", "");
            this.exportPageHeader(pageName, "Main", "TBD", new Date(f.lastModified()), false);
            FileInputStream in = new FileInputStream(f);
            this.exportProperty("wiki:content", FileUtil.readContents(in, "UTF-8"), STRING);
            in.close();
            this.exportPageFooter();
        }
        this.exportDocumentFooter();
        System.out.println("...done");
    }

    private void exportDocumentFooter() {
        this.m_out.println("</sv:node> <!-- EOF -->");
        this.m_out.flush();
    }

    private void exportDocumentHeader() {
        this.m_out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.m_out.println("<!--");
        this.m_out.println("This is an JSR-170 -compliant Document Tree export of a JSPWiki repository.\nIt is meant to be imported to the /pages/ node of the JCR repository, as it\ndescribes an entire wiki space.");
        this.m_out.println("-->");
        this.m_out.println("<sv:node xmlns:jcr='http://www.jcp.org/jcr/1.0' xmlns:nt='http://www.jcp.org/jcr/nt/1.0' xmlns:mix='http://www.jcp.org/jcr/mix/1.0' xmlns:sv='http://www.jcp.org/jcr/sv/1.0' xmlns:wiki='http://www.jspwiki.org/ns#'\n         sv:name='main'>");
    }

    private void exportProperty(String name, String value, String type) {
        this.m_out.println("  <sv:property sv:name='" + StringEscapeUtils.escapeXml((String)name) + "' sv:type='" + type + "'>");
        this.m_out.print("    <sv:value>");
        this.m_out.print(StringEscapeUtils.escapeXml((String)value));
        this.m_out.println("</sv:value>");
        this.m_out.println("  </sv:property>");
    }

    private void exportProperty(String name, String[] values, String type) {
        this.m_out.println("  <sv:property sv:name='" + StringEscapeUtils.escapeXml((String)name) + "' sv:type='" + type + "'>");
        for (String value : values) {
            this.m_out.print("    <sv:value>");
            this.m_out.print(StringEscapeUtils.escapeXml((String)value));
            this.m_out.println("</sv:value>");
        }
        this.m_out.println("  </sv:property>");
    }

    private String mkUuid(String wiki, String name) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(wiki.getBytes("UTF-8"));
        out.write(name.getBytes("UTF-8"));
        return UUID.nameUUIDFromBytes(out.toByteArray()).toString();
    }

    private String guessMimeType(String name, boolean isAttachment) {
        if (isAttachment) {
            return this.m_mimeTypes.getContentType(name);
        }
        return JSPWIKI_CONTENT_TYPE;
    }

    protected void exportPage(WikiEngine engine, WikiPage p) throws IOException, ProviderException {
        String name;
        String title = name = p.getName();
        boolean isAttachment = p instanceof Attachment;
        title = this.generateTitle(name, title, isAttachment);
        this.exportPageHeader(p.getName(), p.getWiki(), p.getAuthor(), p.getLastModified(), isAttachment);
        Map attrMap = p.getAttributes();
        this.exportAttributes(attrMap);
        Acl acl = p.getAcl();
        this.exportAcl(acl);
        this.exportProperty("wiki:content", engine.getPureText(p), STRING);
        this.exportPageFooter();
    }

    private String generateTitle(String name, String title, boolean isAttachment) {
        if (title.contains("/") && !isAttachment) {
            title = title.replace('/', '_');
            System.err.println("Page '" + name + "' will be renamed to '" + title + "', as it contains an illegal character.");
        }
        String tryTitle = title = title.toLowerCase();
        int idx = 1;
        while (this.m_exportedPageTitles.contains(tryTitle)) {
            tryTitle = title + "-" + idx++;
        }
        if (!tryTitle.equals(title)) {
            System.err.println("New case independence rules state that page '" + name + "' will be renamed to '" + tryTitle + "', as there is a conflict already with a page with a similar title.");
            title = tryTitle;
        }
        this.m_exportedPageTitles.add(title);
        if (this.m_verbose) {
            System.out.println("Exporting " + title);
        }
        return title;
    }

    private void exportPageFooter() {
        this.m_out.println(" </sv:node>");
        this.m_out.flush();
    }

    private void exportAcl(Acl acl) {
        if (acl != null) {
            ArrayList<String> propval = new ArrayList<String>();
            Enumeration ee = acl.entries();
            while (ee.hasMoreElements()) {
                AclEntry ae = (AclEntry)ee.nextElement();
                StringBuilder sb = new StringBuilder();
                sb.append("ALLOW \"");
                sb.append(ae.getPrincipal().getName());
                sb.append("\" ");
                Enumeration permissions = ae.permissions();
                while (permissions.hasMoreElements()) {
                    Permission perm = (Permission)permissions.nextElement();
                    sb.append(perm.getActions());
                    sb.append(",");
                }
                propval.add(sb.toString());
            }
            this.exportProperty("wiki:acl", propval.toArray(new String[propval.size()]), STRING);
        }
    }

    private void exportAttributes(Map<String, Object> attrMap) {
        for (Map.Entry<String, Object> e : attrMap.entrySet()) {
            if (e.getKey().equals("changenote")) {
                this.exportProperty("wiki:changeNote", (String)e.getValue(), STRING);
                continue;
            }
            this.exportProperty(e.getKey(), e.getValue().toString(), STRING);
        }
    }

    private void exportPageHeader(String title, String wiki, String author, Date lastModified, boolean isAttachment) throws IOException {
        this.m_out.println(" <sv:node sv:name='" + StringEscapeUtils.escapeXml((String)title.toLowerCase()) + "'>");
        this.exportProperty("jcr:primaryType", "nt:unstructured", NAME);
        this.exportProperty("jcr:mixinTypes", new String[]{"mix:referenceable", "mix:lockable"}, NAME);
        this.exportProperty("wiki:author", author, STRING);
        this.exportProperty("jcr:uuid", this.mkUuid(wiki, title), STRING);
        this.exportProperty("wiki:lastModified", this.m_isoFormat.format(lastModified), DATE);
        this.exportProperty("wiki:contentType", this.guessMimeType(title, isAttachment), STRING);
        this.exportProperty("wiki:title", title, STRING);
    }

    protected void exportPage(WikiEngine engine, Attachment att) throws IOException, ProviderException {
        this.exportPageHeader(att.getName(), att.getWiki(), att.getAuthor(), att.getLastModified(), true);
        this.m_out.println("  <sv:property sv:name='" + att.getFileName() + "' sv:type='" + BINARY + "'>");
        this.m_out.print("<sv:value>");
        InputStream binary = engine.getAttachmentManager().getAttachmentStream(att);
        Base64.InputStream base64 = new Base64.InputStream(binary, 1);
        FileUtil.copyContents(new InputStreamReader((InputStream)base64), this.m_out);
        binary.close();
        this.m_out.println("</sv:value>");
        this.m_out.println("</sv:property>");
        this.exportPageFooter();
    }

    private static final String getParam(String[] s, String p, String defaultParam) {
        if (s.length < 2) {
            return defaultParam;
        }
        if (p == null) {
            String p1 = s[s.length - 2];
            String p2 = s[s.length - 1];
            if (p1.startsWith("-")) {
                return defaultParam;
            }
            return p2;
        }
        for (int i = 0; i < s.length; ++i) {
            if (!s[i].equals(p)) continue;
            if (i < s.length - 1) {
                String p2 = s[i + 1];
                if (p2.startsWith("-")) {
                    return "";
                }
                return p2;
            }
            return "";
        }
        return defaultParam;
    }

    private static final void exit() {
        System.err.println("Usage: com.ecyrd.jspwiki.content.Exporter [--properties <path to jspwiki.properties>] [--dir <versioning file provider dir>] <filename>");
        System.exit(1);
    }

    public static void main(String[] argv) throws IOException {
        String propFile = Exporter.getParam(argv, "--properties", null);
        String outFile = Exporter.getParam(argv, null, null);
        String dir = Exporter.getParam(argv, "--dir", null);
        if (outFile == null) {
            Exporter.exit();
        }
        if (propFile == null && dir == null || propFile != null && dir != null) {
            Exporter.exit();
        }
        if (propFile != null) {
            Exporter.exportWithProperties(propFile, outFile);
        } else {
            Exporter.exportWithDir(dir, outFile);
        }
    }

    public static void exportWithDir(String dir, String outFile) throws IOException {
        FileOutputStream out = new FileOutputStream(new File(outFile));
        Exporter x = new Exporter(out, true);
        x.export(dir);
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportWithProperties(String propFile, String outFile) throws IOException {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(propFile));
        }
        catch (FileNotFoundException e) {
            System.err.println("Property file not found: " + propFile);
            System.exit(2);
        }
        catch (IOException e) {
            System.err.println("Unable to read properties: " + propFile);
            System.exit(2);
        }
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(outFile));
            WikiEngine engine = new WikiEngine(props);
            Exporter x = new Exporter(out, true);
            x.export(engine);
        }
        catch (WikiException e) {
            e.printStackTrace(System.err);
            System.exit(3);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.exit(3);
        }
        finally {
            if (out != null) {
                out.close();
            }
            System.exit(0);
        }
    }
}

