/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.login;

import com.ecyrd.jspwiki.auth.NoSuchPrincipalException;
import com.ecyrd.jspwiki.auth.WikiPrincipal;
import com.ecyrd.jspwiki.auth.login.AbstractLoginModule;
import com.ecyrd.jspwiki.auth.login.UserDatabaseCallback;
import com.ecyrd.jspwiki.auth.user.UserDatabase;
import com.ecyrd.jspwiki.auth.user.UserProfile;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;

public class UserDatabaseLoginModule
extends AbstractLoginModule {
    private static final Logger log = Logger.getLogger(UserDatabaseLoginModule.class);

    public boolean login() throws LoginException {
        UserDatabaseCallback ucb = new UserDatabaseCallback();
        NameCallback ncb = new NameCallback("User name");
        PasswordCallback pcb = new PasswordCallback("Password", false);
        Callback[] callbacks = new Callback[]{ucb, ncb, pcb};
        try {
            this.m_handler.handle(callbacks);
            UserDatabase db = ucb.getUserDatabase();
            String username = ncb.getName();
            String password = new String(pcb.getPassword());
            if (db == null) {
                throw new FailedLoginException("No user database: check the callback handler code!");
            }
            UserProfile profile = db.findByLoginName(username);
            String storedPassword = profile.getPassword();
            if (storedPassword != null && db.validatePassword(username, password)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Logged in user database user " + username));
                }
                this.m_principals.add(new WikiPrincipal(username, "loginName"));
                return true;
            }
            throw new FailedLoginException("The username or password is incorrect.");
        }
        catch (IOException e) {
            String message = "IO exception; disallowing login.";
            log.error((Object)message, (Throwable)e);
            throw new LoginException(message);
        }
        catch (UnsupportedCallbackException e) {
            String message = "Unable to handle callback; disallowing login.";
            log.error((Object)message, (Throwable)e);
            throw new LoginException(message);
        }
        catch (NoSuchPrincipalException e) {
            throw new FailedLoginException("The username or password is incorrect.");
        }
    }
}

