/*
 * Decompiled with CFR 0.152.
 */
package net.jsourcerer.webdriver.jserrorcollector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxProfile;

public class JavaScriptError {
    private final String errorMessage;
    private final String sourceName;
    private final int lineNumber;
    private final String console;

    JavaScriptError(Map<String, ? extends Object> map) {
        this.errorMessage = (String)map.get("errorMessage");
        this.sourceName = (String)map.get("sourceName");
        this.lineNumber = ((Number)map.get("lineNumber")).intValue();
        this.console = (String)map.get("console");
    }

    JavaScriptError(String errorMessage, String sourceName, int lineNumber, String console) {
        this.errorMessage = errorMessage;
        this.sourceName = sourceName;
        this.lineNumber = lineNumber;
        this.console = console;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getConsole() {
        return this.console;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.console == null ? 0 : this.console.hashCode());
        result = 31 * result + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        result = 31 * result + this.lineNumber;
        result = 31 * result + (this.sourceName == null ? 0 : this.sourceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaScriptError other = (JavaScriptError)obj;
        if (this.console == null ? other.console != null : !this.console.equals(other.console)) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.lineNumber != other.lineNumber) {
            return false;
        }
        return !(this.sourceName == null ? other.sourceName != null : !this.sourceName.equals(other.sourceName));
    }

    public String toString() {
        String s = String.valueOf(this.errorMessage) + " [" + this.sourceName + ":" + this.lineNumber + "]";
        if (this.console != null) {
            s = String.valueOf(s) + "\nConsole: " + this.console;
        }
        return s;
    }

    public static List<JavaScriptError> readErrors(WebDriver driver) {
        String script = "return window.JSErrorCollector_errors ? window.JSErrorCollector_errors.pump() : []";
        List errors = (List)((JavascriptExecutor)driver).executeScript("return window.JSErrorCollector_errors ? window.JSErrorCollector_errors.pump() : []", new Object[0]);
        ArrayList<JavaScriptError> response = new ArrayList<JavaScriptError>();
        for (Object rawError : errors) {
            response.add(new JavaScriptError((Map)rawError));
        }
        return response;
    }

    public static void addExtension(FirefoxProfile ffProfile) throws IOException {
        ffProfile.addExtension(JavaScriptError.class, "JSErrorCollector.xpi");
    }
}

