/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.utils.sm;

import com.xuggle.utils.event.AsynchronousEventDispatcher;
import com.xuggle.utils.event.Event;
import com.xuggle.utils.event.EventDispatcherAbortEvent;
import com.xuggle.utils.event.IEvent;
import com.xuggle.utils.event.IEventDispatcher;
import com.xuggle.utils.event.IEventHandler;
import com.xuggle.utils.event.IEventHandlerRegistrable;
import com.xuggle.utils.event.SynchronousEventDispatcher;
import com.xuggle.utils.sm.IState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachine
implements IEventHandlerRegistrable {
    static Logger log = LoggerFactory.getLogger(StateMachine.class);
    private IState mState = null;
    private IState mInitialState = null;
    private IEventDispatcher mDispatcher;

    public StateMachine(IEventDispatcher eventDispatcher, IState initialState) {
        this.mDispatcher = eventDispatcher == null ? new SynchronousEventDispatcher() : eventDispatcher;
        this.mInitialState = initialState;
        this.mState = initialState;
    }

    public void dispatchEvent(IEvent event) {
        this.getEventDispatcher().dispatchEvent(event);
    }

    public IEventDispatcher getEventDispatcher() {
        return this.mDispatcher;
    }

    public void setState(IState target) {
        IState from = this.mState;
        this.mState = target;
        log.debug("State change: " + from + " -> " + this.mState);
        IEvent event = this.newTransitionEvent(this, from, target);
        this.mDispatcher.dispatchEvent(event);
    }

    protected IEvent newTransitionEvent(StateMachine stateMachine, IState from, IState target) {
        return new TransitionEvent(stateMachine, from, target);
    }

    public IState getState() {
        return this.mState;
    }

    public void reset(long timeout) {
        this.mDispatcher.dispatchEvent(new EventDispatcherAbortEvent(this));
        if (this.mDispatcher instanceof AsynchronousEventDispatcher) {
            AsynchronousEventDispatcher aed = (AsynchronousEventDispatcher)this.mDispatcher;
            aed.waitForDispatcherToFinish(timeout);
            this.mState = null;
            aed.startDispatching();
        } else {
            this.mState = null;
        }
        this.setState(this.mInitialState);
    }

    @Override
    public IEventHandlerRegistrable.Key addEventHandler(int priority, Class<? extends IEvent> eventClass, IEventHandler<? extends IEvent> handler) {
        return this.getEventDispatcher().addEventHandler(priority, eventClass, handler);
    }

    @Override
    public void removeEventHandler(IEventHandlerRegistrable.Key key) throws IndexOutOfBoundsException {
        this.getEventDispatcher().removeEventHandler(key);
    }

    @Override
    public IEventHandlerRegistrable.Key addEventHandler(int priority, Class<? extends IEvent> eventClass, IEventHandler<? extends IEvent> handler, boolean useWeakReferences) {
        return this.getEventDispatcher().addEventHandler(priority, eventClass, handler, useWeakReferences);
    }

    public static class TransitionEvent
    extends Event {
        private IState mFrom;
        private IState mTo;

        public TransitionEvent(Object source, IState from, IState to) {
            super(source);
            this.mFrom = from;
            this.mTo = to;
        }

        public IState getFrom() {
            return this.mFrom;
        }

        public IState getTo() {
            return this.mTo;
        }
    }
}

