/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.utils.queue;

import java.util.AbstractQueue;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Queue;

public class ArrayQueue<E>
extends AbstractQueue<E>
implements Queue<E> {
    private E[] mQueue;
    private int mSize;
    private int mFront;
    private int mBack;
    public static int DEFAULT_SIZE = 10;

    public ArrayQueue() {
        this(DEFAULT_SIZE);
    }

    public ArrayQueue(int startingCapacity) {
        if (startingCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.mQueue = new Object[startingCapacity];
        this.mSize = 0;
        this.mFront = 0;
        this.mBack = -1;
    }

    private void growQueue() {
        Object[] newQueue = new Object[this.mQueue.length * 2];
        for (int i = 0; i < this.mSize; ++i) {
            newQueue[i] = this.mQueue[this.mFront];
            ++this.mFront;
            if (this.mFront != this.mQueue.length) continue;
            this.mFront = 0;
        }
        this.mFront = 0;
        this.mBack = this.mSize - 1;
        this.mQueue = newQueue;
    }

    private int getOffset(int index) {
        if (index >= this.mSize || index < 0) {
            return -1;
        }
        int offset = this.mFront + index;
        if (offset >= this.mQueue.length) {
            return offset - this.mQueue.length;
        }
        return offset;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayQueueIterator(this);
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public boolean offer(E obj) {
        if (this.mSize == this.mQueue.length) {
            this.growQueue();
        }
        ++this.mBack;
        if (this.mBack == this.mQueue.length) {
            this.mBack = 0;
        }
        this.mQueue[this.mBack] = obj;
        ++this.mSize;
        return true;
    }

    @Override
    public E peek() {
        return this.mSize == 0 ? null : (E)this.mQueue[this.mFront];
    }

    @Override
    public E poll() {
        if (this.mSize == 0) {
            return null;
        }
        --this.mSize;
        E retval = this.mQueue[this.mFront];
        this.mQueue[this.mFront] = null;
        ++this.mFront;
        if (this.mFront == this.mQueue.length) {
            this.mFront = 0;
        }
        return retval;
    }

    private static class ArrayQueueIterator<E>
    implements Iterator<E> {
        private final ArrayQueue<E> mQueue;
        private final int mQFront;
        private final int mQBack;
        private final E[] mQQueue;
        private final int mQSize;
        private int mIter;

        public ArrayQueueIterator(ArrayQueue<E> q) {
            this.mQueue = q;
            this.mQFront = ((ArrayQueue)q).mFront;
            this.mQBack = ((ArrayQueue)q).mBack;
            this.mQQueue = ((ArrayQueue)q).mQueue;
            this.mQSize = ((ArrayQueue)q).mSize;
            this.mIter = this.mQFront;
        }

        private boolean wasModified() {
            boolean result = this.mQFront != ((ArrayQueue)this.mQueue).mFront || this.mQBack != ((ArrayQueue)this.mQueue).mBack || this.mQSize != ((ArrayQueue)this.mQueue).mSize || this.mQQueue != ((ArrayQueue)this.mQueue).mQueue;
            return result;
        }

        @Override
        public boolean hasNext() {
            if (this.wasModified()) {
                throw new ConcurrentModificationException();
            }
            return this.mIter < this.mQSize;
        }

        @Override
        public E next() {
            if (this.wasModified()) {
                throw new ConcurrentModificationException();
            }
            int offset = ((ArrayQueue)this.mQueue).getOffset(this.mIter);
            if (offset < 0) {
                return null;
            }
            ++this.mIter;
            return this.mQQueue[offset];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

