/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.utils.net;

import com.xuggle.utils.collections.KeyValuePair;
import com.xuggle.utils.collections.MapUtils;
import com.xuggle.utils.net.URLParams;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class YouTube {
    private YouTube() {
    }

    public static Map<String, String> getVideoInfo(String youTubeId) throws IOException {
        HashMap<String, String> retval = new HashMap<String, String>();
        YouTube.getVideoInfo(youTubeId, retval);
        return retval;
    }

    public static void getVideoInfo(String youTubeId, Map<String, String> map) throws IOException {
        URL url;
        String host = "http://www.youtube.com";
        ArrayList<KeyValuePair> params = new ArrayList<KeyValuePair>();
        params.add(new KeyValuePair("video_id", youTubeId));
        String urlString = "http://www.youtube.com/get_video_info?&" + URLParams.generateQueryString(params);
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("malformed url: " + urlString, e);
        }
        byte[] data = new byte[8192];
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (conn.getResponseCode() != 200) {
            conn.disconnect();
            throw new RuntimeException("could not get video info: " + urlString);
        }
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
        int offset = 0;
        int len = 0;
        do {
            if ((offset = in.read(data, offset, data.length - offset)) <= 0) continue;
            len += offset;
        } while (offset >= 0 && offset < data.length);
        conn.disconnect();
        String response = new String(data, 0, len, "UTF-8");
        System.out.println("Response: " + response);
        Map<String, String> youTubeParams = MapUtils.listToMap(URLParams.parseQueryString(response), MapUtils.ListToMapMode.FIRST_WINS);
        String token = youTubeParams.get("token");
        if (token == null) {
            throw new RuntimeException("Could not find youtube token: " + urlString + "; response=" + response);
        }
        params.clear();
        params.add(new KeyValuePair("video_id", youTubeId));
        params.add(new KeyValuePair("t", token));
        String location = "http://www.youtube.com/get_video?" + URLParams.generateQueryString(params);
        map.put("location", location);
        map.putAll(youTubeParams);
    }

    public static String getLocation(String youTubeId) {
        try {
            return YouTube.getVideoInfo(youTubeId).get("location");
        }
        catch (IOException e) {
            throw new RuntimeException("could not get location from youtube", e);
        }
    }

    public static void main(String[] args) {
        try {
            String youTubeId = "nQm-O6jiNsY";
            Map<String, String> params = YouTube.getVideoInfo("nQm-O6jiNsY");
            Set<Map.Entry<String, String>> entries = params.entrySet();
            System.out.println("YouTube ID: nQm-O6jiNsY");
            for (Map.Entry<String, String> entry : entries) {
                System.out.println(entry.getKey() + " = " + entry.getValue());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

