/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.utils.net;

import com.xuggle.utils.collections.IKeyValuePair;
import com.xuggle.utils.collections.KeyValuePair;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class URLParams {
    private URLParams() {
    }

    public static void parseQueryString(String queryString, List<KeyValuePair> paramsToFill) {
        try {
            URLParams.parseQueryString(queryString, paramsToFill, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("What?  UTF-8 isn't a valid encoding", e);
        }
    }

    public static List<KeyValuePair> parseQueryString(String queryString) {
        ArrayList<KeyValuePair> retval = new ArrayList<KeyValuePair>();
        URLParams.parseQueryString(queryString, retval);
        return retval;
    }

    public static List<KeyValuePair> parseQueryString(String queryString, String encoding) throws UnsupportedEncodingException {
        ArrayList<KeyValuePair> retval = new ArrayList<KeyValuePair>();
        URLParams.parseQueryString(queryString, retval, encoding);
        return retval;
    }

    public static void parseQueryString(String queryString, List<KeyValuePair> parametersToFill, String encoding) throws UnsupportedEncodingException {
        String[] params;
        for (String param : params = queryString.split("&")) {
            String[] tuple = param.split("=");
            KeyValuePair retval = new KeyValuePair(URLDecoder.decode(tuple[0], encoding), tuple.length > 1 ? URLDecoder.decode(tuple[1], encoding) : null);
            parametersToFill.add(retval);
        }
    }

    public static String generateQueryString(List<? extends IKeyValuePair> params) {
        try {
            return URLParams.generateQueryString(params, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("What?  UTF-8 isn't a valid encoding", e);
        }
    }

    public static String generateQueryString(List<? extends IKeyValuePair> params, String encoding) throws UnsupportedEncodingException {
        if (params == null) {
            throw new IllegalArgumentException("need params");
        }
        if (encoding == null) {
            throw new UnsupportedEncodingException();
        }
        StringBuilder builder = new StringBuilder();
        Iterator<? extends IKeyValuePair> iterator = params.iterator();
        boolean hasNext = iterator.hasNext();
        while (hasNext) {
            IKeyValuePair pair = iterator.next();
            if (pair != null) {
                String key = pair.getKey();
                String value = pair.getValue();
                builder.append(URLEncoder.encode(key, encoding));
                if (value != null) {
                    builder.append("=");
                    builder.append(URLEncoder.encode(value, encoding));
                }
            }
            if (iterator.hasNext()) {
                if (pair != null) {
                    builder.append("&");
                }
                hasNext = true;
                continue;
            }
            hasNext = false;
        }
        return builder.toString();
    }
}

