/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.utils.event.handler;

import com.xuggle.utils.event.IEvent;
import com.xuggle.utils.event.IEventDispatcher;
import com.xuggle.utils.event.IEventHandler;

public class TargetedHandler<E extends IEvent>
implements IEventHandler<E> {
    private final Object mSource;
    private final IEventHandler<E> mHandler;

    TargetedHandler(Object source, IEventHandler<E> proxiedHandler) {
        this.mSource = source;
        if (proxiedHandler == null) {
            throw new IllegalArgumentException();
        }
        this.mHandler = proxiedHandler;
    }

    public Object getTargetedSource() {
        return this.mSource;
    }

    public IEventHandler<E> getProxiedHandler() {
        return this.mHandler;
    }

    @Override
    public boolean handleEvent(IEventDispatcher dispatcher, E event) {
        if (this.mSource != null && !this.mSource.equals(event.getSource())) {
            return false;
        }
        return this.mHandler.handleEvent(dispatcher, event);
    }
}

