/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.utils.event.handler;

import com.xuggle.utils.event.IEvent;
import com.xuggle.utils.event.IEventDispatcher;
import com.xuggle.utils.event.IEventHandler;
import com.xuggle.utils.event.IEventHandlerRegistrable;
import com.xuggle.utils.event.handler.BoundedHandler;
import com.xuggle.utils.event.handler.ForwardingHandler;
import com.xuggle.utils.event.handler.TargetedHandler;
import java.util.concurrent.atomic.AtomicReference;

public class Handler {
    private Handler() {
    }

    public static ForwardingHandler makeForwardingHandler(IEventDispatcher dispatcherToForwardTo) {
        return new ForwardingHandler(dispatcherToForwardTo);
    }

    public static <E extends IEvent> BoundedHandler<E> makeBoundedHandler(int maxTimesToCall, IEventHandler<E> proxiedHandler) {
        return new BoundedHandler<E>(maxTimesToCall, proxiedHandler);
    }

    public static <E extends IEvent> TargetedHandler<E> makeTargetedHandler(Object source, IEventHandler<E> proxiedHandler) {
        return new TargetedHandler<E>(source, proxiedHandler);
    }

    public static <E extends IEvent> IEventHandler<E> makeTargetedAndBoundedHandler(Object source, int maxTimesToCall, IEventHandler<E> proxiedHandler) {
        BoundedHandler<E> bHandler = Handler.makeBoundedHandler(maxTimesToCall, proxiedHandler);
        TargetedHandler<E> tHandler = Handler.makeTargetedHandler(source, bHandler);
        return tHandler;
    }

    public static <E extends IEvent> IEventHandlerRegistrable.Key register(final IEventHandlerRegistrable registry, int priority, Class<? extends IEvent> eventClass, Object sourceToTarget, int maxTimesToCall, IEventHandler<E> proxiedHandler) {
        if (registry == null) {
            throw new IllegalArgumentException("no registry");
        }
        if (eventClass == null) {
            throw new IllegalArgumentException("no event class");
        }
        if (proxiedHandler == null) {
            throw new IllegalArgumentException("no handler");
        }
        IEventHandler<E> boundedHandler = maxTimesToCall > 0 ? new BoundedHandler<E>(maxTimesToCall, proxiedHandler) : proxiedHandler;
        IEventHandler<E> targetedHandler = sourceToTarget != null ? new TargetedHandler<E>(sourceToTarget, boundedHandler) : boundedHandler;
        final AtomicReference<Object> key = new AtomicReference<Object>(null);
        if (maxTimesToCall > 0) {
            BoundedHandler bHandler = (BoundedHandler)boundedHandler;
            bHandler.setLastEventHandler(new IEventHandler<E>(){

                @Override
                public boolean handleEvent(IEventDispatcher dispatcher, E event) {
                    try {
                        registry.removeEventHandler((IEventHandlerRegistrable.Key)key.get());
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    return false;
                }
            });
        }
        key.set(registry.addEventHandler(priority, eventClass, targetedHandler));
        return key.get();
    }

    public static <E extends IEvent> IEventHandlerRegistrable.Key register(IEventHandlerRegistrable registry, int priority, Class<? extends IEvent> eventClass, int maxTimesToCall, IEventHandler<E> proxiedHandler) {
        return Handler.register(registry, priority, eventClass, null, maxTimesToCall, proxiedHandler);
    }

    public static <E extends IEvent> IEventHandlerRegistrable.Key register(IEventHandlerRegistrable registry, Class<? extends IEvent> eventClass, int maxTimesToCall, IEventHandler<E> proxiedHandler) {
        return Handler.register(registry, 0, eventClass, null, maxTimesToCall, proxiedHandler);
    }

    public static <E extends IEvent> IEventHandlerRegistrable.Key register(IEventHandlerRegistrable registry, Class<? extends IEvent> eventClass, Object sourceToTarget, int maxTimesToCall, IEventHandler<E> proxiedHandler) {
        return Handler.register(registry, 0, eventClass, sourceToTarget, maxTimesToCall, proxiedHandler);
    }

    public static <E extends IEvent> IEventHandlerRegistrable.Key register(IEventHandlerRegistrable registry, int priority, Class<? extends IEvent> eventClass, Object sourceToTarget, IEventHandler<E> proxiedHandler) {
        return Handler.register(registry, priority, eventClass, sourceToTarget, 0, proxiedHandler);
    }

    public static <E extends IEvent> IEventHandlerRegistrable.Key register(IEventHandlerRegistrable registry, Class<? extends IEvent> eventClass, Object sourceToTarget, IEventHandler<E> proxiedHandler) {
        return Handler.register(registry, 0, eventClass, sourceToTarget, 0, proxiedHandler);
    }

    public static <E extends IEvent> IEventHandlerRegistrable.Key register(IEventHandlerRegistrable registry, int priority, Class<? extends IEvent> eventClass, IEventHandler<E> proxiedHandler) {
        return Handler.register(registry, priority, eventClass, null, 0, proxiedHandler);
    }

    public static <E extends IEvent> IEventHandlerRegistrable.Key register(IEventHandlerRegistrable registry, Class<? extends IEvent> eventClass, IEventHandler<E> proxiedHandler) {
        return Handler.register(registry, 0, eventClass, null, 0, proxiedHandler);
    }
}

