/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.utils.event.handler;

import com.xuggle.utils.event.IEvent;
import com.xuggle.utils.event.IEventDispatcher;
import com.xuggle.utils.event.IEventHandler;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class BoundedHandler<E extends IEvent>
implements IEventHandler<E> {
    private final IEventHandler<E> mNullCallbackHandler = new IEventHandler<E>(){

        @Override
        public boolean handleEvent(IEventDispatcher dispatcher, E event) {
            return false;
        }
    };
    private final AtomicInteger mExecCount;
    private final int mMaxExecCount;
    private final IEventHandler<E> mEventHandler;
    private final AtomicReference<IEventHandler<E>> mLastCallHandler;

    BoundedHandler(int maxTimesToCallHandler, IEventHandler<E> proxiedHandler) {
        if (proxiedHandler == null) {
            throw new IllegalArgumentException();
        }
        if (maxTimesToCallHandler <= 0) {
            throw new IllegalArgumentException();
        }
        this.mMaxExecCount = maxTimesToCallHandler;
        this.mEventHandler = proxiedHandler;
        this.mExecCount = new AtomicInteger(0);
        this.mLastCallHandler = new AtomicReference();
        this.mLastCallHandler.set(this.mNullCallbackHandler);
    }

    public void setLastEventHandler(IEventHandler<E> eventHandler) {
        this.mLastCallHandler.compareAndSet(this.mNullCallbackHandler, eventHandler);
    }

    public int getNumTimesExecuted() {
        return this.mExecCount.get();
    }

    public IEventHandler<E> getProxiedHandler() {
        return this.mEventHandler;
    }

    @Override
    public boolean handleEvent(IEventDispatcher dispatcher, E event) {
        int execCount = this.mExecCount.getAndIncrement();
        boolean retval = false;
        if (execCount < this.mMaxExecCount) {
            retval = this.mEventHandler.handleEvent(dispatcher, event);
        }
        if (execCount >= this.mMaxExecCount) {
            IEventHandler callback = this.mLastCallHandler.getAndSet(null);
            if (callback != null && callback != this.mNullCallbackHandler) {
                callback.handleEvent(dispatcher, event);
            }
            this.mExecCount.decrementAndGet();
        }
        return retval;
    }
}

