/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.utils.event;

import com.xuggle.utils.event.ErrorEvent;
import com.xuggle.utils.event.EventHandlerAddedEvent;
import com.xuggle.utils.event.EventHandlerRemovedEvent;
import com.xuggle.utils.event.IEvent;
import com.xuggle.utils.event.IEventDispatcher;
import com.xuggle.utils.event.IEventHandler;
import com.xuggle.utils.event.IEventHandlerRegistrable;
import com.xuggle.utils.event.ISelfHandlingEvent;
import com.xuggle.utils.event.SelfHandlingEvent;
import com.xuggle.utils.queue.ArrayQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class SynchronousEventDispatcher
implements IEventDispatcher {
    private int mNumNestedEventDispatches = 0;
    private final Map<String, ClassHandler> mHandlers = new HashMap<String, ClassHandler>();
    private final Queue<IEvent> mPendingEventDispatches = new ArrayQueue<IEvent>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(IEvent event) {
        long dispatcherNum = ++this.mNumNestedEventDispatches;
        IEvent origEvent = event;
        try {
            origEvent.acquire();
            this.mPendingEventDispatches.offer(origEvent);
            if (dispatcherNum != 1L) {
                return;
            }
            while ((event = this.mPendingEventDispatches.poll()) != null) {
                try {
                    Object[] handlers;
                    InternalKey[] keys;
                    if (event instanceof ISelfHandlingEvent) {
                        ISelfHandlingEvent handler = (ISelfHandlingEvent)event;
                        try {
                            if (handler.handleEvent(this, event)) continue;
                        }
                        catch (AssertionError t) {
                            this.dispatchEvent(new ErrorEvent(event.getSource(), (Throwable)((Object)t), "uncaught exception", event, handler));
                            throw t;
                        }
                        catch (Throwable t) {
                            this.dispatchEvent(new ErrorEvent(event.getSource(), t, "uncaught exception", event, handler));
                        }
                    }
                    String className = event.getClass().getName();
                    Map<String, ClassHandler> map = this.mHandlers;
                    synchronized (map) {
                        ClassHandler classHandler = this.mHandlers.get(className);
                        if (classHandler != null) {
                            keys = classHandler.getSortedKeys();
                            handlers = classHandler.getSortedHandlers();
                        } else {
                            keys = null;
                            handlers = null;
                        }
                    }
                    int numHandlers = keys != null ? keys.length : 0;
                    boolean eventHandled = false;
                    for (int i = 0; i < numHandlers && !eventHandled; ++i) {
                        IEventHandler actualHandler;
                        Object handler = handlers[i];
                        if (handler instanceof WeakReference) {
                            actualHandler = (IEventHandler)((WeakReference)handler).get();
                            if (actualHandler == null) {
                                final InternalKey removeKey = keys[i];
                                this.dispatchEvent(new SelfHandlingEvent<IEvent>((Object)this){

                                    @Override
                                    public boolean handleEvent(IEventDispatcher aDispatcher, IEvent aEvent) {
                                        try {
                                            SynchronousEventDispatcher.this.removeEventHandler(removeKey);
                                        }
                                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                        return false;
                                    }
                                });
                                continue;
                            }
                        } else {
                            actualHandler = (IEventHandler)handler;
                        }
                        try {
                            eventHandled = actualHandler.handleEvent(this, event);
                            continue;
                        }
                        catch (AssertionError t) {
                            this.dispatchEvent(new ErrorEvent(event.getSource(), (Throwable)((Object)t), "uncaught exception", event, actualHandler));
                            throw t;
                        }
                        catch (Throwable t) {
                            this.dispatchEvent(new ErrorEvent(event.getSource(), t, "uncaught exception", event, actualHandler));
                        }
                    }
                }
                finally {
                    event.release();
                }
            }
        }
        finally {
            --this.mNumNestedEventDispatches;
        }
    }

    @Override
    public IEventHandlerRegistrable.Key addEventHandler(int priority, Class<? extends IEvent> eventClass, IEventHandler<? extends IEvent> handler) {
        return this.addEventHandler(priority, eventClass, handler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IEventHandlerRegistrable.Key addEventHandler(int priority, Class<? extends IEvent> eventClass, IEventHandler<? extends IEvent> handler, boolean useWeakReferences) {
        if (eventClass == null) {
            throw new IllegalArgumentException();
        }
        if (handler == null) {
            throw new IllegalArgumentException();
        }
        String eventName = eventClass.getName();
        InternalKey key = new InternalKey(priority, eventClass, useWeakReferences ? new WeakReference<IEventHandler<? extends IEvent>>(handler) : handler);
        Map<String, ClassHandler> map = this.mHandlers;
        synchronized (map) {
            ClassHandler classHandler = this.mHandlers.get(eventName);
            if (classHandler == null) {
                classHandler = new ClassHandler();
                this.mHandlers.put(eventName, classHandler);
            }
            classHandler.addEventHandler(key);
        }
        this.dispatchEvent(new EventHandlerAddedEvent(this, key, priority, eventClass, handler, useWeakReferences));
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEventHandler(IEventHandlerRegistrable.Key key) throws IndexOutOfBoundsException {
        if (key == null) {
            throw new IndexOutOfBoundsException();
        }
        if (!(key instanceof InternalKey)) {
            throw new IndexOutOfBoundsException("Key not generated by this class");
        }
        InternalKey iKey = (InternalKey)key;
        String eventName = iKey.getEventClass().getName();
        int priority = iKey.getPriority();
        Object handler = iKey.getHandler();
        Map<String, ClassHandler> map = this.mHandlers;
        synchronized (map) {
            ClassHandler classHandler = this.mHandlers.get(eventName);
            if (classHandler == null) {
                throw new IndexOutOfBoundsException();
            }
            classHandler.removeEventHandler(iKey);
            if (classHandler.getNumHandlers() <= 0) {
                this.mHandlers.remove(eventName);
            }
        }
        if (handler instanceof WeakReference) {
            handler = ((WeakReference)handler).get();
        }
        this.dispatchEvent(new EventHandlerRemovedEvent(this, key, priority, iKey.getEventClass(), (IEventHandler)handler));
    }

    private static class InternalKey
    implements IEventHandlerRegistrable.Key {
        private final int mPriority;
        private final Class<? extends IEvent> mEventClass;
        private final Object mHandler;

        public InternalKey(int priority, Class<? extends IEvent> eventClass, Object handler) {
            this.mPriority = priority;
            this.mEventClass = eventClass;
            this.mHandler = handler;
        }

        public int getPriority() {
            return this.mPriority;
        }

        public Class<? extends IEvent> getEventClass() {
            return this.mEventClass;
        }

        public Object getHandler() {
            return this.mHandler;
        }
    }

    private static class ClassHandler {
        private InternalKey[] mKeys = null;
        private Object[] mHandlers = null;
        private final SortedMap<Integer, List<InternalKey>> mPriorities = new TreeMap<Integer, List<InternalKey>>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2.compareTo(o1);
            }
        });

        private ClassHandler() {
        }

        private void refreshHandlers() {
            ArrayList<Object> handlers = new ArrayList<Object>();
            ArrayList<InternalKey> keys = new ArrayList<InternalKey>();
            Set<Integer> priorityKeys = this.mPriorities.keySet();
            for (Integer priority : priorityKeys) {
                List priHandlers = (List)this.mPriorities.get(priority);
                if (priHandlers == null) continue;
                for (InternalKey reference : priHandlers) {
                    handlers.add(reference.getHandler());
                    keys.add(reference);
                }
            }
            this.mHandlers = new Object[keys.size()];
            this.mHandlers = handlers.toArray(this.mHandlers);
            this.mKeys = new InternalKey[keys.size()];
            this.mKeys = keys.toArray(this.mKeys);
        }

        public void addEventHandler(InternalKey key) {
            int priority = key.getPriority();
            LinkedList<InternalKey> handlers = (LinkedList<InternalKey>)this.mPriorities.get(priority);
            if (handlers == null) {
                handlers = new LinkedList<InternalKey>();
                this.mPriorities.put(priority, handlers);
            }
            handlers.add(key);
            this.refreshHandlers();
        }

        public void removeEventHandler(InternalKey key) {
            List handlers = (List)this.mPriorities.get(key.getPriority());
            if (handlers == null) {
                throw new IndexOutOfBoundsException();
            }
            Iterator iter = handlers.iterator();
            int numRemoved = 0;
            while (iter.hasNext() && numRemoved == 0) {
                InternalKey ref = (InternalKey)iter.next();
                if (!key.equals(ref)) continue;
                iter.remove();
                ++numRemoved;
                break;
            }
            if (handlers.size() == 0) {
                this.mPriorities.remove(key.getPriority());
            }
            this.refreshHandlers();
            if (numRemoved != 1) {
                throw new IndexOutOfBoundsException();
            }
        }

        public int getNumHandlers() {
            return this.mKeys == null ? 0 : this.mKeys.length;
        }

        public InternalKey[] getSortedKeys() {
            return this.mKeys;
        }

        public Object[] getSortedHandlers() {
            return this.mHandlers;
        }
    }
}

