/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.utils.event;

import com.xuggle.utils.event.IEvent;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Event
implements IEvent {
    private final Object mSource;
    private final long mNow;
    private final AtomicLong mRefCount;

    public Event(Object aSource) {
        this.mSource = aSource;
        this.mNow = System.nanoTime();
        this.mRefCount = new AtomicLong(0L);
    }

    @Override
    public Object getSource() {
        return this.mSource;
    }

    @Override
    public long getWhen() {
        return this.mNow;
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("source=").append(this.getSource()).append(";");
        builder.append("when=").append(this.getWhen()).append(";");
        return builder.toString();
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("[");
        builder.append(this.getDescription());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public long acquire() {
        return this.mRefCount.incrementAndGet();
    }

    @Override
    public void delete() {
        if (this.mRefCount.get() != 0L) {
            throw new IllegalStateException("attempt to delete when valid references remain");
        }
    }

    @Override
    public long release() {
        long retval = this.mRefCount.decrementAndGet();
        if (retval <= 0L) {
            this.delete();
        }
        return retval;
    }
}

