/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.utils.event;

import com.xuggle.utils.event.Event;
import com.xuggle.utils.event.IEvent;
import com.xuggle.utils.event.IEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorEvent
extends Event {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String mMessage;
    private final Throwable mException;
    private final IEventHandler<? extends IEvent> mHandler;
    private final IEvent mEvent;

    ErrorEvent(Object source, Throwable t, String message, IEvent event, IEventHandler<? extends IEvent> handler) {
        super(source);
        this.mMessage = message;
        this.mException = t;
        this.mHandler = handler;
        this.mEvent = event;
        if (this.mEvent != null) {
            this.mEvent.acquire();
        }
        this.log.info("Error: {}", (Object)this);
    }

    ErrorEvent(Object source, Throwable t, String message, IEvent event) {
        this(source, t, message, event, null);
    }

    public ErrorEvent(Object source, Throwable t, String message) {
        this(source, t, message, null, null);
    }

    public ErrorEvent(Object source, String message) {
        this(source, null, message, null, null);
    }

    public ErrorEvent(Object source, Throwable t) {
        this(source, t, null, null, null);
    }

    public ErrorEvent(Object source) {
        this(source, null, null, null, null);
    }

    public String getMessage() {
        return this.mMessage;
    }

    @Override
    public String getDescription() {
        Throwable t;
        String message;
        IEventHandler<? extends IEvent> handler;
        StringBuilder string = new StringBuilder();
        string.append(super.getDescription());
        IEvent event = this.getEvent();
        if (event != null) {
            string.append("event=" + event + ";");
        }
        if ((handler = this.getHandler()) != null) {
            string.append("handler=" + handler + ";");
        }
        if ((message = this.getMessage()) != null && message.length() > 0) {
            string.append("\n");
            string.append("message=" + message + ";");
        }
        if ((t = this.getException()) != null) {
            string.append("trace=\n");
            string.append(t);
            string.append("\n");
            StackTraceElement[] elements = t.getStackTrace();
            if (elements != null && elements.length > 0) {
                int i = 0;
                for (StackTraceElement elem : elements) {
                    string.append(elem.toString() + "\n");
                    if (++i >= 15) break;
                }
                string.append(";");
            }
        }
        return string.toString();
    }

    public Throwable getException() {
        return this.mException;
    }

    public IEventHandler<? extends IEvent> getHandler() {
        return this.mHandler;
    }

    public IEvent getEvent() {
        return this.mEvent;
    }

    @Override
    public void delete() {
        if (this.mEvent != null) {
            this.mEvent.release();
        }
    }
}

