/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.utils.event;

import com.xuggle.utils.event.EventDispatcherAbortEvent;
import com.xuggle.utils.event.EventDispatcherStopEvent;
import com.xuggle.utils.event.IAsynchronousEventDispatcher;
import com.xuggle.utils.event.IEvent;
import com.xuggle.utils.event.SynchronousEventDispatcher;
import com.xuggle.utils.queue.ArrayQueue;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousEventDispatcher
extends SynchronousEventDispatcher
implements IAsynchronousEventDispatcher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Thread mDispatchThread;
    private final Queue<IEvent> mEventQueue;
    private final String mThreadName;

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(super.toString());
        b.append("[").append(this.mThreadName).append("];");
        return b.toString();
    }

    public AsynchronousEventDispatcher(String threadName, boolean autoStartDispatching) {
        if (threadName == null) {
            threadName = "DispatcherThread_" + this.hashCode();
        }
        this.mThreadName = threadName;
        this.mDispatchThread = null;
        this.mEventQueue = new ArrayQueue<IEvent>(50);
        this.setupDispatching();
        if (autoStartDispatching) {
            this.startDispatching();
        }
    }

    public AsynchronousEventDispatcher(boolean autoStartDispatching) {
        this(null, autoStartDispatching);
    }

    public AsynchronousEventDispatcher(String threadName) {
        this(threadName, false);
    }

    public AsynchronousEventDispatcher() {
        this(false);
    }

    private void setupDispatching() {
        this.mDispatchThread = new Thread(new Runnable(){

            @Override
            public void run() {
                AsynchronousEventDispatcher.this.runDispatcherThread();
            }
        }, this.mThreadName);
        this.mDispatchThread.setDaemon(true);
    }

    @Override
    public synchronized void startDispatching() {
        if (this.mDispatchThread == null || this.mDispatchThread.getState() == Thread.State.TERMINATED) {
            this.setupDispatching();
        }
        if (this.mDispatchThread.isAlive()) {
            return;
        }
        assert (this.mDispatchThread != null) : "Error; could not create thread";
        this.mDispatchThread.start();
    }

    @Override
    public void stopDispatching() {
        this.dispatchEvent(new EventDispatcherStopEvent(this));
    }

    @Override
    public void abortDispatching() {
        this.dispatchEvent(new EventDispatcherAbortEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForDispatcherToFinish(long timeout) {
        Thread dispatchThread = null;
        AsynchronousEventDispatcher asynchronousEventDispatcher = this;
        synchronized (asynchronousEventDispatcher) {
            if (this.mDispatchThread.isAlive()) {
                dispatchThread = this.mDispatchThread;
            }
        }
        if (dispatchThread != null) {
            try {
                dispatchThread.join(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isDispatching() {
        return this.mDispatchThread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(IEvent event) {
        if (event == null) {
            return;
        }
        AsynchronousEventDispatcher asynchronousEventDispatcher = this;
        synchronized (asynchronousEventDispatcher) {
            event.acquire();
            this.log.trace("dispatchEvent({})", (Object)event);
            if (event instanceof EventDispatcherAbortEvent) {
                IEvent queueEvent;
                while ((queueEvent = this.mEventQueue.poll()) != null) {
                    queueEvent.release();
                }
                this.log.debug("aborting dispatcher");
            }
            this.mEventQueue.offer(event);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDispatcherThread() {
        boolean keepRunning = true;
        while (keepRunning) {
            int numPendingEvents = 0;
            IEvent pollEvent = null;
            AsynchronousEventDispatcher asynchronousEventDispatcher = this;
            synchronized (asynchronousEventDispatcher) {
                while (pollEvent == null) {
                    numPendingEvents = this.mEventQueue.size();
                    pollEvent = this.mEventQueue.poll();
                    if (pollEvent != null) continue;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        pollEvent = new EventDispatcherAbortEvent(this);
                    }
                }
            }
            IEvent event = pollEvent;
            if (event instanceof EventDispatcherStopEvent || event instanceof EventDispatcherAbortEvent || Thread.currentThread().isInterrupted()) {
                AsynchronousEventDispatcher e = this;
                synchronized (e) {
                    IEvent queueEvent;
                    this.log.debug("Got request to shut down");
                    keepRunning = false;
                    while ((queueEvent = this.mEventQueue.poll()) != null) {
                        queueEvent.release();
                    }
                }
                event.release();
                continue;
            }
            try {
                this.log.trace("pending events: {}; dispatchEvent({})", (Object)numPendingEvents, (Object)event);
                try {
                    super.dispatchEvent(event);
                }
                finally {
                    event.release();
                }
            }
            catch (Throwable t) {
                this.log.error("Dispatcher continuing after unhandled event: {}", t);
                t.printStackTrace();
            }
        }
    }
}

