/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.utils.collections;

import com.xuggle.utils.collections.IMultiMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultiMap<A, B>
implements IMultiMap<A, B> {
    private final Map<A, Set<B>> mAtoB = new HashMap<A, Set<B>>();
    private final Map<B, Set<A>> mBtoA = new HashMap<B, Set<A>>();

    @Override
    public Set<A> getMappedA(B key) {
        Set<A> retval = this.mBtoA.get(key);
        if (retval == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(retval);
    }

    @Override
    public Set<B> getMappedB(A key) {
        Set<B> retval = this.mAtoB.get(key);
        if (retval == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(retval);
    }

    @Override
    public boolean map(A a, B b) {
        boolean retval;
        if (a == null || b == null) {
            throw new NullPointerException();
        }
        Set<B> aSet = this.mAtoB.get(a);
        Set<A> bSet = this.mBtoA.get(b);
        if (aSet == null) {
            aSet = new HashSet<B>();
            this.mAtoB.put(a, aSet);
        }
        if (retval = aSet.add(b)) {
            if (bSet == null) {
                bSet = new HashSet<A>();
                this.mBtoA.put(b, bSet);
            }
            boolean check = bSet.add(a);
            assert (check) : "did not add to bSet but added to aSet";
        }
        return retval;
    }

    @Override
    public boolean unmap(A a, B b) {
        boolean retval;
        if (a == null || b == null) {
            throw new NullPointerException();
        }
        Set<B> aSet = this.mAtoB.get(a);
        Set<A> bSet = this.mBtoA.get(b);
        if (aSet != null) {
            if (aSet.remove(b)) {
                assert (bSet != null) : "had a but no b";
                boolean check = bSet.remove(a);
                assert (check) : "removed from a but not b";
                if (bSet.size() == 0) {
                    this.mBtoA.remove(b);
                }
                if (aSet.size() == 0) {
                    this.mAtoB.remove(a);
                }
                retval = true;
            } else {
                retval = true;
            }
        } else {
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean removeAllA(A key) {
        Set<B> set = this.mAtoB.remove(key);
        if (set == null) {
            return false;
        }
        assert (set.size() > 0) : "unexpected empty set";
        for (B value : set) {
            Set<A> mirror = this.mBtoA.get(value);
            assert (mirror != null) : "not bi-directional";
            if (mirror == null) continue;
            boolean check = mirror.remove(key);
            assert (check) : "not bi-directional";
            if (mirror.size() != 0) continue;
            this.mBtoA.remove(value);
        }
        return true;
    }

    @Override
    public boolean removeAllB(B key) {
        Set<A> set = this.mBtoA.remove(key);
        if (set == null) {
            return false;
        }
        assert (set.size() > 0) : "unexpected empty set";
        for (A value : set) {
            Set<B> mirror = this.mAtoB.get(value);
            assert (mirror != null) : "not bi-directional";
            if (mirror == null) continue;
            boolean check = mirror.remove(key);
            assert (check) : "not bi-directional";
            if (mirror.size() != 0) continue;
            this.mAtoB.remove(value);
        }
        return true;
    }

    public String toString() {
        Set<Object> values;
        StringBuilder builder = new StringBuilder();
        builder.append("mAtoB(").append(this.mAtoB.size()).append("):\n");
        for (Object key : this.mAtoB.keySet()) {
            builder.append(key).append("=[");
            values = this.mAtoB.get(key);
            for (B b : values) {
                builder.append(b).append(", ");
            }
            builder.append("]\n");
        }
        builder.append("mBtoA(").append(this.mBtoA.size()).append("):\n");
        for (Object key : this.mBtoA.keySet()) {
            builder.append(key).append("=[");
            values = this.mBtoA.get(key);
            for (Object object : values) {
                builder.append(object).append(", ");
            }
            builder.append("]\n");
        }
        return builder.toString();
    }
}

