/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.utils.collections;

import com.xuggle.utils.collections.IKeyValuePair;
import com.xuggle.utils.collections.KeyValuePair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapUtils {
    public static void listToMap(List<? extends IKeyValuePair> list, Map<String, String> mapToFill, ListToMapMode mode) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        if (mapToFill == null) {
            throw new IllegalArgumentException();
        }
        mapToFill.clear();
        for (IKeyValuePair iKeyValuePair : list) {
            String oldValue;
            if (iKeyValuePair == null) continue;
            String key = iKeyValuePair.getKey();
            String value = iKeyValuePair.getValue();
            if (mode == ListToMapMode.FIRST_WINS && mapToFill.containsKey(key) || mode == ListToMapMode.FIRST_NONEMPTY_WINS && mapToFill.containsKey(key) && (oldValue = mapToFill.get(key)) != null && oldValue.length() > 0 || mode == ListToMapMode.LAST_NONEMPTY_WINS && (value == null || value.length() == 0) && mapToFill.containsKey(key)) continue;
            mapToFill.put(key, value);
        }
    }

    public static Map<String, String> listToMap(List<? extends IKeyValuePair> list, ListToMapMode mode) {
        HashMap<String, String> retval = new HashMap<String, String>();
        MapUtils.listToMap(list, retval, mode);
        return retval;
    }

    public static void mapToList(Map<String, String> map, List<IKeyValuePair> listToFill) {
        if (map == null || listToFill == null) {
            throw new IllegalArgumentException();
        }
        Set<Map.Entry<String, String>> entries = map.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (name == null) continue;
            KeyValuePair pair = new KeyValuePair(name, value);
            listToFill.add(pair);
        }
    }

    public static List<IKeyValuePair> mapToList(Map<String, String> map) {
        ArrayList<IKeyValuePair> retval = new ArrayList<IKeyValuePair>();
        MapUtils.mapToList(map, retval);
        return retval;
    }

    public static enum ListToMapMode {
        LAST_WINS,
        FIRST_WINS,
        FIRST_NONEMPTY_WINS,
        LAST_NONEMPTY_WINS;

    }
}

