/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.utils;

import com.xuggle.utils.TimeValue;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class Tracer {
    private final UUID mID;
    private final Object mSource;
    private final Object mMessage;
    private final TimeValue mTimeStamp;
    private final long mElapsedNanoSeconds;
    private final TimeValue mElapsedTime;
    private final Tracer mParent;

    private Tracer(Object source, Object message, TimeValue timestamp, Tracer parent) {
        if (source == null) {
            throw new NullPointerException();
        }
        this.mSource = source;
        this.mMessage = message;
        if (timestamp == null) {
            timestamp = TimeValue.nanoNow();
        }
        this.mTimeStamp = timestamp;
        if (parent == null) {
            this.mID = UUID.randomUUID();
            this.mParent = null;
            this.mElapsedNanoSeconds = 0L;
        } else {
            this.mID = parent.getID();
            this.mParent = parent;
            this.mElapsedNanoSeconds = timestamp.get(TimeUnit.NANOSECONDS) - this.mParent.getTimeStamp().get(TimeUnit.NANOSECONDS) + this.mParent.mElapsedNanoSeconds;
        }
        this.mElapsedTime = new TimeValue(this.mElapsedNanoSeconds, TimeUnit.NANOSECONDS);
    }

    public Tracer(Object source, Object message, TimeValue timestamp) {
        this(source, message, timestamp, null);
    }

    public Tracer(Object source, Object message) {
        this(source, message, null, null);
    }

    public Tracer(Object source) {
        this(source, null, null, null);
    }

    public Tracer stamp(Object source, Object message, TimeValue timestamp) {
        return new Tracer(source, message, timestamp, this);
    }

    public Tracer stamp(Object source, TimeValue timestamp) {
        return this.stamp(source, null, timestamp);
    }

    public Tracer stamp(Object source) {
        return this.stamp(source, null, null);
    }

    public UUID getID() {
        return this.mID;
    }

    public Object getSource() {
        return this.mSource;
    }

    public TimeValue getTimeStamp() {
        return this.mTimeStamp;
    }

    public Object getMessage() {
        return this.mMessage;
    }

    public Tracer getParent() {
        return this.mParent;
    }

    public Tracer findAncestor(Object source) {
        for (Tracer current = this; null != current; current = current.getParent()) {
            if (current.getSource() != source) continue;
            return current;
        }
        return null;
    }

    public Tracer findOriginator() {
        Tracer current = this;
        while (null != current.getParent()) {
            current = current.getParent();
        }
        return current;
    }

    public long difference(Tracer tracer, TimeUnit unit) {
        return Tracer.difference(this, tracer, unit);
    }

    public static long difference(Tracer a, Tracer b, TimeUnit unit) {
        return b.getTimeStamp().get(unit) - a.getTimeStamp().get(unit);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<tracer");
        builder.append(" id=\"");
        builder.append(this.mID);
        builder.append("\"");
        builder.append(" instance=\"");
        builder.append(this.hashCode());
        builder.append("\"");
        builder.append(" ts=\"");
        builder.append(this.mTimeStamp.getValue());
        builder.append("\"");
        TimeUnit unit = this.mTimeStamp.getUnit();
        if (!TimeUnit.NANOSECONDS.equals((Object)unit)) {
            builder.append(" unit=\"");
            builder.append((Object)this.mTimeStamp.getUnit());
            builder.append("\"");
        }
        builder.append(" elapsed=\"");
        builder.append(this.mElapsedTime.getValue());
        builder.append("\"");
        TimeUnit elapsedunit = this.mElapsedTime.getUnit();
        if (!TimeUnit.NANOSECONDS.equals((Object)elapsedunit)) {
            builder.append(" elapsedunit=\"");
            builder.append((Object)this.mElapsedTime.getUnit());
            builder.append("\"");
        }
        builder.append(">");
        builder.append("<source>");
        builder.append(this.mSource);
        builder.append("</source>");
        if (this.mMessage != null) {
            builder.append("<message>");
            builder.append(this.mMessage);
            builder.append("</message>");
        }
        if (this.mParent != null) {
            builder.append(this.mParent);
        }
        builder.append("</tracer>");
        return builder.toString();
    }

    public TimeValue getElapsedTime() {
        return this.mElapsedTime;
    }
}

