/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.utils;

import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;

public final class TimeValue
implements Comparable<TimeValue> {
    private long mValue;
    private TimeUnit mUnit;

    public TimeValue() {
        this.setValue(0L);
        this.setUnit(TimeUnit.MILLISECONDS);
    }

    public TimeValue(long aValue, TimeUnit aUnit) {
        this.setValue(aValue);
        this.setUnit(aUnit);
    }

    public TimeValue(long value, String unit) {
        this(value, TimeUnit.valueOf(unit));
    }

    public static TimeValue nanoNow() {
        return new TimeValue(System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    public static TimeValue now() {
        return new TimeValue(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public TimeValue(TimeValue aSrc) {
        if (aSrc == null) {
            throw new IllegalArgumentException("must pass valid time value");
        }
        this.setValue(aSrc.getValue());
        this.setUnit(aSrc.getUnit());
    }

    public long get(TimeUnit aUnit) {
        if (aUnit == null) {
            throw new IllegalArgumentException("must pass valid TimeUnit");
        }
        return aUnit.convert(this.getValue(), this.getUnit());
    }

    public TimeUnit getTimeUnit() {
        return this.getUnit();
    }

    public TimeValue copy() {
        return new TimeValue(this.getValue(), this.getUnit());
    }

    @Override
    public int compareTo(TimeValue that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            throw new NullPointerException();
        }
        TimeUnit minUnit = this.getUnit();
        if (that.getUnit().ordinal() < minUnit.ordinal()) {
            minUnit = that.getUnit();
        }
        long thisNs = minUnit.convert(this.getValue(), this.getUnit());
        long thatNs = minUnit.convert(that.getValue(), that.getUnit());
        long maxDistance = 0x3FFFFFFFFFFFFFFFL;
        int adjustment = 1;
        if (thisNs > 0x3FFFFFFFFFFFFFFFL && thatNs <= -4611686018427387903L || thatNs > 0x3FFFFFFFFFFFFFFFL && thisNs <= -4611686018427387903L) {
            adjustment = -1;
        }
        return thisNs < thatNs ? -adjustment : (thisNs > thatNs ? adjustment : 0);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that != null && that.getClass().equals(this.getClass())) {
            return this.compareTo((TimeValue)that) == 0;
        }
        return false;
    }

    public int hashCode() {
        return (int)TimeUnit.NANOSECONDS.convert(this.getValue(), this.getUnit());
    }

    public String toString() {
        DecimalFormat format = new DecimalFormat("###,###,###,###,###,###,###");
        String s = format.format(this.getValue());
        return s + " (" + (Object)((Object)this.getUnit()) + ")";
    }

    public void setValue(long value) {
        this.mValue = value;
    }

    public long getValue() {
        return this.mValue;
    }

    public void setUnit(TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("must specify unit");
        }
        this.mUnit = unit;
    }

    public TimeUnit getUnit() {
        return this.mUnit;
    }
}

