/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.test_utils;

import java.util.ConcurrentModificationException;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public class NameAwareTestClassRunner
extends BlockJUnit4ClassRunner {
    private static Object mClassLock = new Object();
    private static String mGlobalTestClassName = null;
    private static String mGlobalTestMethodName = null;
    private static final ThreadLocal<String> testClassName = new ThreadLocal();
    private static final ThreadLocal<String> testMethodName = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setName(String name) {
        testMethodName.set(NameAwareTestClassRunner.extractTestMethodName(name));
        testClassName.set(NameAwareTestClassRunner.extractTestClassName(name));
        Object object = mClassLock;
        synchronized (object) {
            mGlobalTestClassName = testClassName.get();
            mGlobalTestMethodName = testMethodName.get();
        }
    }

    public static String getTestName() {
        return String.format("%s(%s)", NameAwareTestClassRunner.getTestMethodName(), NameAwareTestClassRunner.getTestClassName());
    }

    public static String getTestMethodName() {
        String methodName = testMethodName.get();
        if (methodName == null) {
            methodName = mGlobalTestMethodName;
        }
        return methodName;
    }

    public static String getTestClassName() {
        String className = testClassName.get();
        if (className == null) {
            className = mGlobalTestClassName;
        }
        return className;
    }

    public NameAwareTestClassRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public void run(RunNotifier notifier) {
        notifier.addListener((RunListener)new NameListener());
        super.run(notifier);
    }

    private static String extractTestMethodName(String name) {
        if (name != null) {
            int last = name.lastIndexOf(40);
            String methodName = last < 0 ? name : name.substring(0, last);
            return methodName;
        }
        return null;
    }

    private static String extractTestClassName(String name) {
        if (name != null) {
            int last = name.lastIndexOf(40);
            return last < 0 ? null : name.substring(last + 1, name.length() - 1);
        }
        return null;
    }

    private static class NameListener
    extends RunListener {
        private NameListener() {
        }

        public void testStarted(Description description) {
            NameAwareTestClassRunner.setName(description.isTest() ? description.getDisplayName() : null);
        }

        public void testFinished(Description description) {
            if (NameAwareTestClassRunner.getTestMethodName() != null) {
                if (NameAwareTestClassRunner.getTestName().equals(description.getDisplayName())) {
                    NameAwareTestClassRunner.setName(null);
                } else {
                    throw new ConcurrentModificationException("Test name mismatch. Was " + description.getDisplayName() + " expected " + NameAwareTestClassRunner.getTestName());
                }
            }
        }
    }
}

