/*
 * Decompiled with CFR 0.152.
 */
package com.java2html;

import com.java2html.BadOptionException;
import com.java2html.CommandLineOptionProcessor;
import com.java2html.Helper;
import com.java2html.JavaDoc;
import com.java2html.JavaDocManager;
import com.java2html.JavaSource;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class Java2HTML {
    private int marginSize = 0;
    private int tabSize = 4;
    private boolean header = true;
    private boolean footer = true;
    private boolean simple = false;
    private String title = "Java Source";
    private String[] javaSourceFileList = null;
    private JavaDoc[] javaDocOptionList = null;
    private String destination = "output";

    public static void main(String[] stringArray) {
        int n = 0;
        System.out.println("Java2HTML Version 1.5");
        System.out.println(Helper.copyRight);
        Java2HTML java2HTML = new Java2HTML();
        CommandLineOptionProcessor commandLineOptionProcessor = new CommandLineOptionProcessor(stringArray);
        try {
            if (!commandLineOptionProcessor.setOptionsFromCommandLine(java2HTML)) {
                return;
            }
            java2HTML.buildJava2HTML();
        }
        catch (Exception exception) {
            System.err.print(exception.getMessage());
            n = 1;
        }
        System.exit(n);
    }

    public boolean buildJava2HTML() throws Exception {
        this.createSupportingFiles();
        JavaDocManager javaDocManager = new JavaDocManager(this.javaDocOptionList);
        if (this.javaSourceFileList == null) {
            this.setJavaDirectorySource(new String[]{"."});
        }
        JavaSource javaSource = new JavaSource(this.javaSourceFileList, this.destination, this.marginSize, this.tabSize, this.header, this.footer, javaDocManager);
        if (!this.simple) {
            javaSource.createPackageIndex(this.destination, this.title);
        }
        javaSource.generateJava2HTML();
        return true;
    }

    private void createSupportingFiles() throws IOException {
        new File(this.destination).mkdirs();
        File file = null;
        FileWriter fileWriter = null;
        file = new File(this.destination + File.separator + "stylesheet.css");
        fileWriter = new FileWriter(file);
        fileWriter.write(Helper.getStyleSheet());
        fileWriter.close();
        System.out.println("Created " + file.getAbsolutePath());
        if (!this.simple) {
            file = new File(this.destination + File.separator + "front.html");
            fileWriter = new FileWriter(file);
            fileWriter.write(Helper.getFront());
            fileWriter.close();
            System.out.println("Created " + file.getAbsolutePath());
            file = new File(this.destination + File.separator + "index.html");
            fileWriter = new FileWriter(file);
            fileWriter.write(Helper.getFrame(this.title));
            fileWriter.close();
        }
    }

    public void setMarginSize(int n) {
        this.marginSize = n;
    }

    public void setTabSize(int n) {
        this.tabSize = n;
    }

    public void setHeader(boolean bl) {
        this.header = bl;
    }

    public void setSimple(boolean bl) {
        this.simple = bl;
    }

    public void setFooter(boolean bl) {
        this.footer = bl;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setJavaDirectorySource(String[] stringArray) throws BadOptionException {
        int n;
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            if (file.isDirectory()) continue;
            throw new BadOptionException(stringArray[i] + " is not a directory");
        }
        Vector vector = new Vector();
        for (n = 0; n < stringArray.length; ++n) {
            vector = Helper.getFileListFromDirectory(stringArray[n], vector);
        }
        this.javaSourceFileList = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            this.javaSourceFileList[n] = (String)vector.elementAt(n);
        }
    }

    public void setJavaFileSource(String[] stringArray) {
        this.javaSourceFileList = stringArray;
    }

    public void setJavaDoc(JavaDoc[] javaDocArray) {
        this.javaDocOptionList = javaDocArray;
    }

    public void setDestination(String string) {
        this.destination = string;
    }
}

